/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bigpicture.server;

import com.roninpixels.dashboardhub.connectors.impl.bigpicture.BigPictureConnectorImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigPictureConnectorServerImpl
extends BigPictureConnectorImpl {
    public static final String APP_SUBPATH = "/rest/softwareplant-bigpicture/1.0";
    private static final Logger log = LoggerFactory.getLogger(BigPictureConnectorServerImpl.class);

    public BigPictureConnectorServerImpl(ServerConnector connector) {
        super(connector);
    }

    boolean checkVersion(String version) {
        String[] v = version.split("\\.");
        int major = Integer.parseInt(v[0]);
        int minor = Integer.parseInt(v[1]);
        int bugfix = v.length > 2 ? Integer.parseInt(v[2]) : 0;
        int build = v.length > 3 ? Integer.parseInt(v[3]) : 0;
        return major > 8 || major == 8 && (minor > 24 || minor == 24 && (bugfix > 0 || build >= 2));
    }

    @Override
    public boolean isValid() {
        try {
            Map systemInfoMap = this.getSystemInfo();
            String version = (String)systemInfoMap.get("systemVersion");
            if (!this.checkVersion(version)) {
                throw new DhUserException(400, "INCOMPATIBLE_VERSION", String.format("Version not supported: %s", version));
            }
        }
        catch (DhUserException dhe) {
            throw dhe;
        }
        catch (BadRequestToSourceException bre) {
            throw new DhUserException("INVALID_INSTANCE", "error", bre.getResponseEntity());
        }
        catch (Exception e) {
            log.error("Error validating BigPicture connector", (Throwable)e);
            return false;
        }
        return true;
    }
}

