/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.action;

import com.roninpixels.dashboardhub.config.action.DHShowActionBase;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.ProtectedWallboard;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.exceptions.InvalidBoardException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.SharedBoardModel;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHShowSharedAction
extends DHShowActionBase {
    private static final Logger log = LoggerFactory.getLogger(DHShowSharedAction.class);
    @Inject
    private PerformanceSettingsController performanceSettingsController;
    @Inject
    private DHObjectMapper mapper;
    private BoardModel board;

    public boolean isExternal() {
        return true;
    }

    @Override
    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig(true);
            config.setExternal(this.isExternal());
            this.setSharedBoard(config);
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    private void setSharedBoard(FrontendConfigModel config) {
        try {
            SharedBoardModel sharedBoard = SharedBoardModel.shortBean(this.board);
            config.setSharedBoard(this.mapper.writeValueAsString(sharedBoard));
            if (this.board.getSharing().getPassword() != null) {
                config.setProtectedWallboard(new ProtectedWallboard(this.board.getId(), this.board.getToken()));
            } else {
                config.setWallboard(this.mapper.writeValueAsString(this.board));
            }
        }
        catch (Exception e) {
            throw new InvalidBoardException("Problems getting a board for public sharing -> " + this.tokenData.getBoardId(), e);
        }
    }

    @Override
    public String getAppConfig() {
        AppConfigModel appConfig = new AppConfigModel();
        appConfig.setRestrictedAccess(false);
        appConfig.setPerformanceSettings(this.performanceSettingsController.getPerformanceSettings());
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    @Override
    public void validate() {
        if (this.tokenData == null) {
            throw new InvalidBoardException("No token provided");
        }
        try {
            this.board = this.boardsController.getUserBoard(this.tokenData.getUsserAccountId(), this.tokenData.getBoardId(), this.tokenData.getGlobal());
        }
        catch (Exception e) {
            throw new InvalidBoardException("It is not possible to retrieve the board.", e);
        }
        if (this.board == null || this.board.getSharing() == null || !this.board.getSharing().getPublic().booleanValue()) {
            throw new InvalidBoardException("The board is not available: " + this.board.getId());
        }
    }
}

