/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.exceptions.InvalidBoardException;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DashboardHubServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubServlet.class);
    protected static final String RESOURCE = "resources";
    public static final String PATH_INVALID_BOARD = "/reactApp/app/html/invalid_wallboard.html";
    @Inject
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private Provider<DHShowAction> actionsProvider;
    private String resources;

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    protected abstract Map<String, Object> getInitialContext();

    protected abstract String getTemplatePath();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            Map<String, Object> context = this.getInitialContext();
            context.put("resp", resp);
            context.put("scope", Collections.singletonList(this.resources));
            DHAction action = this.getAction(req);
            action.validate();
            context.put("dh", action);
            context.put("action", action);
            resp.setHeader("Content-Type", "text/html");
            this.templateRenderer.render(this.getTemplatePath(), context, (Writer)resp.getWriter());
        }
        catch (InvalidBoardException ibe) {
            resp.setHeader("Content-Type", "text/html");
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_INVALID_BOARD);
            ServletOutputStream respOutStream = resp.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)respOutStream);
            respOutStream.flush();
        }
    }

    protected DHAction getAction(HttpServletRequest req) {
        TokenContentModel tokenContent = this.getTokenData(req, "ac.boardToken");
        DHShowAction action = (DHShowAction)this.actionsProvider.get();
        action.setToken(tokenContent);
        return action;
    }

    protected TokenContentModel getTokenData(HttpServletRequest request, String tokenParamName) {
        String token = request.getParameter(tokenParamName);
        if (token != null) {
            try {
                return this.tokenGenerator.getTokenContent(token);
            }
            catch (Exception e) {
                throw new InvalidBoardException("Invalid token", e);
            }
        }
        return null;
    }
}

