/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/suggestions")
public class JQLSuggestionsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JQLSuggestionsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @Produces(value={"application/json"})
    public Response getSuggestions(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @Context UriInfo ui) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            MultivaluedMap params = ui.getQueryParameters();
            ResponseEntity<List> response = jira.getJqlSuggestions((Map<String, ?>)params);
            return GenericJiraEndpoint.generateResponse(response);
        }
        catch (Exception e) {
            log.error("Problems getting jql suggestions", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

