/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.performance;

import com.roninpixels.dashboardhub.config.frontedModel.PerformanceSettingsModel;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.performance.PerformanceSettingsMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceSettingsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PerformanceSettingsEndpoint.class);
    @Inject
    private PerformanceSettingsController performanceSettingsController;
    @Inject
    private DHUserService dhUserService;

    public Response setPerformanceSettings(PerformanceSettingsMessageModel message) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            PerformanceSettingsModel newSettings = new PerformanceSettingsModel();
            newSettings.setRefreshTime(message.getRefreshTime());
            newSettings.setMaxIssueNumber(message.getMaxIssueNumber());
            newSettings.setParallelRequests(message.getParallelRequests());
            this.performanceSettingsController.updatePerformanceSettings(newSettings);
            HashMap<String, Boolean> responseData = new HashMap<String, Boolean>();
            responseData.put("ok", true);
            return ResponseBuilder.ok(responseData).build();
        }
        catch (NotAuthorizedException nae) {
            log.error("Problems updating the access configuration", (Throwable)nae);
            return Response.status((int)403).build();
        }
        catch (IllegalArgumentException iae) {
            log.error("Problems updating the access configuration", (Throwable)iae);
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            log.error("Problems updating the access configuration", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

