/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.confluence.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.controllers.impl.ConfluenceUsersControllerImpl;
import com.roninpixels.dashboardhub.web.rest.base.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.base.confluence.api.ConfluenceBulkUsersRequest;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/confluence/v1/users")
public class BulkUsersEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BulkUsersEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull ConfluenceBulkUsersRequest request) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ConfluenceUsersControllerImpl confluenceUsersController = new ConfluenceUsersControllerImpl(confluence);
            return ResponseBuilder.ok(confluenceUsersController.getBulkUsers(request.getUserKeys(), request.getUserNames(), request.getMaxResults())).build();
        }
        catch (Exception e) {
            return MessagesUtil.generateErrorResponse(500, "Error searching users");
        }
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    public Response searchByTerm(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @QueryParam(value="searchTerm") String searchTerm, @QueryParam(value="limit") Integer limit) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ConfluenceUsersControllerImpl confluenceUsersController = new ConfluenceUsersControllerImpl(confluence);
            List<Map> users = confluenceUsersController.searchUsers(searchTerm, limit != null ? limit : 10);
            return ResponseBuilder.ok(users).build();
        }
        catch (Exception e) {
            log.error("Problems searching users", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

