/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.atlassianV1.dashboardHub.datasources;

import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.CreateDatasourceMessage;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.DatasourceEndpointSrv;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class DatasourceEndpointWrapperAtlasV1 {
    private static final Logger log = LoggerFactory.getLogger(DatasourceEndpointWrapperAtlasV1.class);
    @Inject
    private DatasourceEndpointSrv datasourceEndpointSrv;

    @GET
    @Path(value="/datasource/{id}")
    @Produces(value={"application/json"})
    public Response getDatasourceWithExtraInfo(@NotNull @PathParam(value="id") String id) {
        return this.datasourceEndpointSrv.getDatasourceWithExtraInfo(id);
    }

    @POST
    @Path(value="/datasource")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(CreateDatasourceMessage message) {
        return this.datasourceEndpointSrv.create(message);
    }

    @PUT
    @Path(value="/datasource/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@NotNull @PathParam(value="id") String id, CreateDatasourceMessage message) {
        return this.datasourceEndpointSrv.update(id, message);
    }

    @DELETE
    @Path(value="/datasource/{id}")
    @Produces(value={"application/json"})
    public Response delete(@NotNull @PathParam(value="id") String id, @DefaultValue(value="false") @QueryParam(value="private") Boolean isPrivate) {
        return this.datasourceEndpointSrv.delete(id, isPrivate);
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatasources(@DefaultValue(value="false") @QueryParam(value="private") Boolean isPrivate, @HeaderParam(value="wallboardbehave") String wallBoardBehave) {
        return this.datasourceEndpointSrv.getDatasources(isPrivate, wallBoardBehave);
    }
}

