/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.permissions;

import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import com.roninpixels.dashboardhub.web.models.UserGroupsModel;
import java.util.List;
import java.util.Map;

public class BoardRestrictionsConfig {
    private List<String> canEditUsers;
    private List<String> canEditGroups;
    private List<String> canEditProjects;
    private List<String> canViewUsers;
    private List<String> canViewGroups;
    private List<String> canViewProjects;

    public List<String> getCanEditProjects() {
        return this.canEditProjects;
    }

    public List<String> getCanViewProjects() {
        return this.canViewProjects;
    }

    public BoardRestrictionsConfig(RestrictionsModel restrictions) {
        UserGroupsModel userGroups = restrictions != null ? restrictions.getUserGroups() : null;
        Map<String, List<String>> editConfig = RestrictionsUtil.breakDownUsersGroupsProjects(userGroups == null ? null : userGroups.getCanEdit());
        this.canEditGroups = editConfig.get("groups");
        this.canEditUsers = editConfig.get("users");
        this.canEditProjects = editConfig.get("projects");
        Map<String, List<String>> viewConfig = RestrictionsUtil.breakDownUsersGroupsProjects(userGroups == null ? null : userGroups.getCanView());
        this.canViewGroups = viewConfig.get("groups");
        this.canViewUsers = viewConfig.get("users");
        this.canViewProjects = viewConfig.get("projects");
    }

    public boolean canViewUser(String userKey) {
        return this.canViewUsers.contains(userKey);
    }

    public boolean canViewGroup(String group) {
        return this.canViewGroups.contains(group);
    }

    public boolean canViewProject(String project) {
        return this.canViewProjects.contains(project);
    }

    public boolean canEditUser(String userKey) {
        return this.canEditUsers.contains(userKey);
    }

    public boolean canEditGroup(String group) {
        return this.canEditGroups.contains(group);
    }

    public boolean canEditProject(String project) {
        return this.canEditProjects.contains(project);
    }
}

