/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.DHDatasource;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.store.DHStoreObjectCallback;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHDatasourcesRepositoryImpl
implements DHDatasourcesRepository {
    private static final Logger log = LoggerFactory.getLogger(DHDatasourcesRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @Inject
    private Crypto crypto;
    private final DHObjectMapper mMapper;

    @Inject
    public DHDatasourcesRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate, DHObjectMapper mapper) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = mapper;
    }

    @Override
    public boolean addDatasource(DatasourceModel dsModel) throws IOException {
        String value = this.mMapper.writeValueAsString(dsModel);
        return null != this.transactionTemplate.execute(() -> {
            boolean isPrivate = dsModel.getPrivate() == null ? false : dsModel.getPrivate();
            DHDatasource ds = (DHDatasource)this.ao.create(DHDatasource.class, new DBParam[]{new DBParam("KEY", (Object)dsModel.getId()), new DBParam("OWNER", (Object)dsModel.getCreator()), new DBParam("PRIVATE", (Object)isPrivate), new DBParam("VALUE", (Object)value)});
            ds.save();
            log.debug("Datasource created -> " + ds.getKey());
            return ds;
        });
    }

    @Override
    public boolean updateDatasource(DatasourceModel dsModel) throws IOException {
        String value = this.mMapper.writeValueAsString(dsModel);
        return null != this.transactionTemplate.execute(() -> {
            DHDatasource target = this.findDatasource(dsModel.getId());
            target.setPrivate(dsModel.getPrivate());
            target.setValue(value);
            target.save();
            log.debug("Datasource updated -> " + target.getKey());
            return target;
        });
    }

    @Override
    public DatasourceModel getDatasource(String key) throws IOException {
        DHDatasource ds = this.findDatasource(key);
        return ds == null ? null : this.transform(ds);
    }

    @Override
    public DatasourceModel getDatasourceWithExtraInfo(String key) throws IOException {
        DHDatasource ds = this.findDatasource(key);
        return ds == null ? null : this.transformExtraInfo(ds);
    }

    @Override
    public DatasourceModel removeDatasource(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        DHDatasource ds = (DHDatasource)this.transactionTemplate.execute(() -> {
            DHDatasource targetDS = this.findDatasource(id);
            if (targetDS != null) {
                this.ao.delete(new RawEntity[]{targetDS});
            }
            return targetDS;
        });
        return ds != null ? this.transform(ds) : null;
    }

    @Override
    public List<DatasourceModel> getGlobalDatasources() {
        Query query = Query.select().where("PRIVATE = ?", new Object[]{false});
        DHDatasource[] globalDSs = (DHDatasource[])this.ao.find(DHDatasource.class, query);
        return this.transform(globalDSs);
    }

    @Override
    public List<DatasourceModel> getPrivateDatasources(String ownerKey) throws IOException {
        Query query = Query.select().where("PRIVATE = ? AND OWNER = ?", new Object[]{true, ownerKey});
        DHDatasource[] globalDSs = (DHDatasource[])this.ao.find(DHDatasource.class, query);
        return this.transform(globalDSs);
    }

    @Override
    public List<DatasourceModel> getPrivateDatasources() throws IOException {
        Query query = Query.select().where("PRIVATE = ?", new Object[]{true});
        DHDatasource[] queryDSs = (DHDatasource[])this.ao.find(DHDatasource.class, query);
        return this.transform(queryDSs);
    }

    @Override
    public List<DatasourceModel> getDatasourcesWithPermissions(String userKey) throws IOException {
        List<DatasourceModel> datasourcesWithPernission = Stream.concat(this.getPrivateDatasources(userKey).stream(), this.getGlobalDatasources().stream()).collect(Collectors.toList());
        return datasourcesWithPernission;
    }

    public void stream(DHStoreObjectCallback callback) {
        this.ao.stream(DHDatasource.class, dsObj -> callback.onObjectRead(this.transform((DHDatasource)dsObj)));
    }

    private DHDatasource findDatasource(String key) {
        Query query = Query.select().where("KEY = ?", new Object[]{key});
        DHDatasource[] userProps = (DHDatasource[])this.ao.find(DHDatasource.class, query);
        if (userProps.length == 0) {
            return null;
        }
        if (userProps.length > 1) {
            throw new RuntimeException(String.format("There are more than one property with same key: %s", key));
        }
        return userProps[0];
    }

    private List<DatasourceModel> transform(DHDatasource[] datasources) {
        return Arrays.stream(datasources).map(ds -> this.transform((DHDatasource)ds)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private DatasourceModel transform(DHDatasource ds) {
        try {
            return this.mMapper.readValue(ds.getValue(), DatasourceModel.class);
        }
        catch (IOException ioe) {
            log.warn("Stored datasource invalid!!! -> " + ds.getKey());
            return null;
        }
    }

    private DatasourceModel transformExtraInfo(DHDatasource ds) {
        try {
            boolean hasToken;
            DatasourceModel dsParsed = this.mMapper.readValue(ds.getValue(), DatasourceModel.class);
            DsOptionsModel options = DatasourcesUtil.decryptOptions(this.crypto, dsParsed.getToken());
            if (options != null && options.getOtherConfig() != null && options.getOtherConfig().get("options") != null && ((hasToken = ((Map)options.getOtherConfig().get("options")).containsKey("token")) || dsParsed.getProduct().equals("customreports"))) {
                if (dsParsed.getOptions() == null) {
                    dsParsed.setOptions(new DsOptionsModel());
                }
                if (hasToken) {
                    dsParsed.getOptions().addOtherConfig("hasToken", true);
                }
                if (dsParsed.getProduct().equals("customreports")) {
                    dsParsed.getOptions().addOtherConfig("type", ((Map)options.getOtherConfig().get("options")).get("type"));
                }
            }
            return dsParsed;
        }
        catch (IOException ioe) {
            log.warn("Stored datasource invalid!!! -> " + ds.getKey());
            return null;
        }
    }
}

