/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.PivotTablesConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SearchConfig {
    private List<String> columns = new LinkedList<String>();
    private List<String> fields = new LinkedList<String>();
    private List<List<String>> aggregations = new LinkedList<List<String>>();
    private List<String> calculatedFields;
    private List<String> chartAggregation;
    private String chartBy;
    private String chartGroup;
    private Boolean group;
    private Boolean isHorizontal;
    private Boolean isNormalized;
    private Boolean showZeroValues;
    private String view;
    private PivotTablesConfig pivotTables;

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<List<String>> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<List<String>> aggregations) {
        this.aggregations = aggregations;
    }

    public List<String> getCalculatedFields() {
        return this.calculatedFields;
    }

    public void setCalculatedFields(List<String> calculatedFields) {
        this.calculatedFields = calculatedFields;
    }

    public List<String> getChartAggregation() {
        return this.chartAggregation;
    }

    public void setChartAggregation(List<String> chartAggregation) {
        this.chartAggregation = chartAggregation;
    }

    public String getChartBy() {
        return this.chartBy;
    }

    public void setChartBy(String chartBy) {
        this.chartBy = chartBy;
    }

    public String getChartGroup() {
        return this.chartGroup;
    }

    public void setChartGroup(String chartGroup) {
        this.chartGroup = chartGroup;
    }

    public Boolean getGroup() {
        return this.group;
    }

    public void setGroup(Boolean group) {
        this.group = group;
    }

    public Boolean getHorizontal() {
        return this.isHorizontal;
    }

    public void setHorizontal(Boolean horizontal) {
        this.isHorizontal = horizontal;
    }

    public Boolean getNormalized() {
        return this.isNormalized;
    }

    public void setNormalized(Boolean normalized) {
        this.isNormalized = normalized;
    }

    public Boolean getShowZeroValues() {
        return this.showZeroValues;
    }

    public void setShowZeroValues(Boolean showZeroValues) {
        this.showZeroValues = showZeroValues;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public PivotTablesConfig getPivotTables() {
        return this.pivotTables;
    }

    public void setPivotTables(PivotTablesConfig pivotTables) {
        this.pivotTables = pivotTables;
    }

    public List<String> getColumnsAndFields() {
        LinkedList<String> fields = new LinkedList<String>(this.columns);
        fields.addAll(this.getFields());
        switch (this.getView()) {
            case "multilinechart": 
            case "stackedbarchart": 
            case "groupedbarchart": 
            case "stackedareachart": 
            case "multipiechart": {
                fields.add(this.chartGroup);
            }
            case "funnelchart": 
            case "tilechart": 
            case "linechart": 
            case "piechart": 
            case "barchart": 
            case "areachart": {
                String chartBy = this.getChartBy();
                fields.add(chartBy);
                String chartAggregation = this.getChartAggregation().get(1);
                fields.add(chartAggregation);
                break;
            }
            case "pivottable": 
            case "pivottable2d": {
                fields.addAll(this.getPivotTables().getRowColumns());
                fields.add(this.getPivotTables().getAggregationField());
                if (!"pivottable2d".equals(this.getView())) break;
                fields.addAll(this.getPivotTables().getColumnColumns());
            }
        }
        if (this.getGroup() != null) {
            fields.addAll(this.getAggregations().stream().map(agg -> (String)agg.get(1)).filter(field -> !fields.contains(field)).collect(Collectors.toList()));
        }
        return fields;
    }
}

