/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.AgileIssuesProvider;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.JQLAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProviderBasedOnSprints
extends AgileIssuesProvider {
    private static final Logger log = LoggerFactory.getLogger(ProviderBasedOnSprints.class);

    List<Map> populateWithProjects(List<Map> sprints) {
        Map<Object, List> projectsByBoardId = sprints.stream().map(sprint -> sprint.get("originBoardId")).map(boardId -> {
            ResponseEntity<List> response = this.jiraConnector.getBoardProjects(((Number)boardId).longValue());
            ResponseChecker.checkStatus(response);
            return new Object[]{boardId, response.getBody()};
        }).collect(Collectors.toMap(objects -> objects[0], objects -> (List)objects[1], (existing, replacement) -> {
            LinkedList newList = new LinkedList();
            newList.addAll(existing);
            newList.addAll(replacement);
            return newList;
        }));
        return sprints.stream().map(sprint -> {
            HashMap newSprint = new HashMap(sprint);
            newSprint.put("projects", projectsByBoardId.get(sprint.get("originBoardId")));
            return newSprint;
        }).collect(Collectors.toList());
    }

    private List<Map> getSprints(AgileGadgetConfig config) {
        List<Map> sprints = config.getSprints().stream().map(sprintDef -> this.jiraConnector.getSprint(sprintDef.getValue())).collect(Collectors.toList());
        try {
            sprints = this.populateWithProjects(sprints);
        }
        catch (BadRequestToSourceException badRequestToSourceException) {
            // empty catch block
        }
        return sprints;
    }

    @Override
    public AgileGadgetReponseData getAgileData(AgileGadgetConfig config, List<String> extraParams) {
        List<Map> sprints = this.getSprints(config);
        List<Map> issues = this.getAgileData(config, extraParams, sprints, null);
        return new AgileGadgetReponseData(JiraDataUtils.removeDuplicate(sprints), JiraDataUtils.removeDuplicate(issues));
    }

    @Override
    public JQLAndSprints getJQLAndSprintsData(AgileGadgetConfig config, List<String> extraParams) {
        List<Map> sprints = this.getSprints(config);
        String jql = sprints.isEmpty() ? null : this.jiraSprintUtils.generateJQL(sprints, extraParams.get(0), null);
        return new JQLAndSprints(JiraDataUtils.removeDuplicate(sprints), jql);
    }
}

