/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsCloud;
import com.roninpixels.dashboardhub.utils.filter.FilterUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class JiraSprintDataUtils {
    private static final Logger log = LoggerFactory.getLogger(JiraSprintDataUtils.class);
    private static final Map<String, String> GET_SPRINTS_PARAMS;
    private static final String SPRINT_CUSTOM_SCHEMA = "com.pyxis.greenhopper.jira:gh-sprint";
    private static final Pattern ID_PATTERN;
    private static final Pattern NAME_PATTERN;

    public static Map createResponse(List activeSprints, List issues) {
        HashMap<String, List> entityBody = new HashMap<String, List>();
        entityBody.put("sprints", activeSprints == null ? new LinkedList() : activeSprints);
        entityBody.put("issues", issues == null ? new LinkedList() : issues);
        return entityBody;
    }

    public static Map getActiveSprint(List<Map> sprints) {
        return sprints == null ? null : (Map)sprints.stream().filter(sprint -> "active".equals(sprint.get("state"))).findFirst().orElse(null);
    }

    public static Map getActiveSprint(List<Map> sprints, Long boardId) {
        return sprints == null ? null : (Map)sprints.stream().filter(sprint -> "active".equals(sprint.get("state")) && boardId.equals(sprint.get("originBoardId"))).findFirst().orElse(null);
    }

    public static List<Map> getSprints(JiraConnector jiraConnector, Long boardId, Map params) {
        ResponseEntity<List> sprintsResponse = jiraConnector.getBoardsSprints(boardId, params, "");
        return sprintsResponse.getStatusCode().value() >= 400 ? null : (List)sprintsResponse.getBody();
    }

    public static List<Map> getSprintsWithProjects(JiraConnector jiraConnector, Long boardId, Map params) {
        if (jiraConnector.isCloud()) {
            return JiraSprintDataUtilsCloud.getSprintsWithProjects(jiraConnector, boardId, params);
        }
        List<Map> sprints = JiraSprintDataUtils.getSprints(jiraConnector, boardId, params);
        List<Map> sprintsWithProject = JiraSprintDataUtils.getSprintsWithProjects(jiraConnector, sprints);
        return sprintsWithProject;
    }

    public static List retrieveActiveSprintsWithProjects(JiraConnector jiraConnector, Long boardId) {
        if (jiraConnector.isCloud()) {
            return JiraSprintDataUtilsCloud.retrieveActiveSprintsWithProjects(jiraConnector, boardId);
        }
        List<Map> sprints = JiraSprintDataUtils.getSprints(jiraConnector, boardId, GET_SPRINTS_PARAMS);
        List<Map> sprintsWithProject = JiraSprintDataUtils.getSprintsWithProjects(jiraConnector, sprints);
        return sprintsWithProject;
    }

    public static List<Map> getSprintsWithProjects(JiraConnector jiraConnector, List<Map> sprints) {
        List<Map> sprintsWithProject = sprints.stream().map(sprint -> {
            sprint.put("projects", JiraSprintDataUtils.getSprintProjects(jiraConnector, sprint));
            return sprint;
        }).collect(Collectors.toList());
        return sprintsWithProject;
    }

    private static List<Map> getSprintProjects(JiraConnector jiraConnector, Map sprint) {
        Object originBoardId = sprint.get("originBoardId");
        if (originBoardId == null) {
            return Collections.emptyList();
        }
        long boardId = ((Number)originBoardId).longValue();
        ResponseEntity<List> projectsResponse = jiraConnector.getBoardProjects(boardId);
        List projects = (List)projectsResponse.getBody();
        return projects;
    }

    public static List getSprintIssues(JiraConnector jiraConnector, Map activeSprint, List<String> metric, List<String> defaultFields, String sprintClause) {
        LinkedList<String> fields = new LinkedList<String>();
        if (defaultFields != null) {
            fields.addAll(defaultFields);
        }
        if (metric != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(metric));
        }
        return jiraConnector.execJQL(String.format("%s = %s", sprintClause, activeSprint.get("id")), ListUtils.union(fields, FilterUtils.USER_FILTER_FIELDS), Arrays.asList("changelog"), null, null, "").getIssues();
    }

    public static String generateJQL(List<Map> sprints, String sprintClause, String filterId) {
        LinkedList<String> clauses = new LinkedList<String>();
        if (filterId != null) {
            clauses.add(String.format("filter = %s", filterId));
        }
        if (!sprints.isEmpty()) {
            String sprintsIds = sprints.stream().map(sprint -> sprint.get("id").toString()).collect(Collectors.joining(","));
            clauses.add(String.format("%s in (%s)", sprintClause, sprintsIds));
        }
        return clauses.stream().collect(Collectors.joining(" AND "));
    }

    public static List getSprintIssues(JiraConnector jiraConnector, List<Map> sprints, List<String> metric, List<String> defaultFields, String sprintClause, String filterId) {
        LinkedList<String> fields = new LinkedList<String>();
        if (defaultFields != null) {
            fields.addAll(defaultFields);
        }
        if (metric != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(metric));
        }
        String jql = JiraSprintDataUtils.generateJQL(sprints, sprintClause, filterId);
        List<Map> issues = jiraConnector.execJQL(jql, ListUtils.union(fields, FilterUtils.USER_FILTER_FIELDS), Arrays.asList("changelog"), null, null, "").getIssues();
        return issues;
    }

    static Long extractSprintId(String greenhopperClassStr) {
        Matcher matcher = ID_PATTERN.matcher(greenhopperClassStr);
        if (!matcher.find()) {
            return null;
        }
        return Long.valueOf(matcher.group());
    }

    static String extractSprintName(String greenhopperClassStr) {
        Matcher matcher = NAME_PATTERN.matcher(greenhopperClassStr);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group();
    }

    static Long extractSprintId(Map sprint) {
        if (sprint.get("id") instanceof String) {
            return Long.valueOf((String)sprint.get("id"));
        }
        return ((Number)sprint.get("id")).longValue();
    }

    static String extractSprintName(Map sprint) {
        return sprint.getOrDefault("name", "").toString();
    }

    static Long extractSprintId(Object sprint) {
        return sprint instanceof Map ? JiraSprintDataUtils.extractSprintId((Map)sprint) : JiraSprintDataUtils.extractSprintId((String)sprint);
    }

    static String extractSprintName(Object sprint) {
        return sprint instanceof Map ? JiraSprintDataUtils.extractSprintName((Map)sprint) : JiraSprintDataUtils.extractSprintName((String)sprint);
    }

    public static void fixSprintField(List<Map> issues, List<Map> sprints, String sprintField) {
        Map<Long, Map> mappedSprints = sprints.stream().collect(Collectors.toMap(sprint -> ((Number)sprint.get("id")).longValue(), sprint -> sprint));
        issues.parallelStream().forEach(issue -> {
            Map fields = (Map)issue.get("fields");
            List values = (List)fields.get(sprintField);
            if (values != null) {
                List ids = values.stream().map(value -> JiraSprintDataUtils.extractSprintId(value)).filter(Objects::nonNull).collect(Collectors.toList());
                List newValue = ids.stream().map(id -> (Map)mappedSprints.get(id)).filter(Objects::nonNull).collect(Collectors.toList());
                fields.put(sprintField, newValue);
            }
        });
    }

    public static void fixSprintField(List<HashMap> issues, List<Field> fieldList) {
        issues.stream().forEach(issue -> {
            LinkedHashMap issueFields = (LinkedHashMap)issue.get("fields");
            if (issueFields != null) {
                issueFields.entrySet().stream().forEach(entry -> {
                    List greenhopperClassStrList;
                    LinkedHashMap schema;
                    Map.Entry entryMap = (Map.Entry)entry;
                    Optional<Field> field = fieldList.stream().filter(fieldCheck -> fieldCheck.getId().equals(entryMap.getKey())).findFirst();
                    if (field.isPresent() && field.get().getOtherFields() != null && field.get().getOtherFields().get("schema") != null && (schema = (LinkedHashMap)field.get().getOtherFields().get("schema")).get("custom") != null && schema.get("custom").equals(SPRINT_CUSTOM_SCHEMA) && entryMap.getValue() != null && (greenhopperClassStrList = (List)entryMap.getValue()) != null && greenhopperClassStrList.size() > 0) {
                        issueFields.put(field.get().getId(), JiraSprintDataUtils.extractSprintName((String)greenhopperClassStrList.get(0)));
                    }
                });
                issue.put("fields", issueFields);
            }
        });
    }

    public static List<String> extractFieldsNamesFromMetric(List<String> metric) {
        if (metric != null && metric.size() > 1 && metric.get(1) != null) {
            String fields = metric.get(1);
            return Arrays.asList(fields.split(","));
        }
        return Collections.emptyList();
    }

    public static List<Map> filterSprintsByState(List<Map> allSprints, List<String> allowedStates) {
        return allSprints == null || allowedStates == null || allowedStates.isEmpty() ? allSprints : allSprints.stream().filter(sprint -> allowedStates.contains((String)sprint.get("state"))).collect(Collectors.toList());
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "active");
        GET_SPRINTS_PARAMS = Collections.unmodifiableMap(map);
        ID_PATTERN = Pattern.compile("(?<=id=).*?(?=\\,)");
        NAME_PATTERN = Pattern.compile("(?<=name=).*?(?=\\,)");
    }
}

