/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class DsGeneratorBase
implements Generator {
    DatasourceModel generateBasicInfoFrom(DatasourceModel dsDef) {
        DatasourceModel newDs = new DatasourceModel();
        String id = dsDef.getId() != null ? dsDef.getId() : UUID.randomUUID().toString();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setUrl(dsDef.getUrl().trim());
        newDs.setProduct(dsDef.getProduct());
        newDs.setCreator(dsDef.getCreator());
        newDs.setCreated(dsDef.getCreated());
        if (newDs.getCreated() == null) {
            newDs.setCreated(new Date());
        } else {
            newDs.setUpdated(new Date());
        }
        return newDs;
    }

    void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        if (dsDef.getUrl().trim().isEmpty()) {
            throw new RuntimeException("INVALID_INSTANCE");
        }
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
    }
}

