/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.DsGeneratorBase;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="customreports")
public class CustomReportsDs
extends DsGeneratorBase {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsDs.class);
    private static final String PRODUCT_CR = Product.CUSTOM_REPORTS.value();
    public static final List<String> API_TOKEN_ADD_TO_VALUES = Arrays.asList("header", "query");
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;
    private static final List<String> PRODUCTS = Arrays.asList(PRODUCT_CR);

    @Override
    public boolean match(DatasourceModel def) {
        return PRODUCTS.contains(def.getProduct());
    }

    DsOptionsModel generateOptions(DsOptionsModel options) {
        DsOptionsModel finalOptions = new DsOptionsModel();
        LinkedList headers = new LinkedList();
        List dsHeaders = options.getOption("headers", List.class);
        if (dsHeaders != null && !dsHeaders.isEmpty()) {
            headers.addAll(dsHeaders);
        }
        finalOptions.addOtherConfig("headers", headers);
        LinkedList params = new LinkedList();
        List dsParams = options.getOption("params", List.class);
        if (dsParams != null && !dsParams.isEmpty()) {
            params.addAll(dsParams);
        }
        finalOptions.addOtherConfig("params", params);
        String type = options.getOption("type", String.class);
        finalOptions.addOtherConfig("type", type);
        switch (type) {
            case "basic": {
                String username = options.getOption("username");
                String password = options.getOption("password");
                if (username == null || password == null) {
                    throw new BadDatasourceException("Invalid datasource: basic auth without credentials");
                }
                finalOptions.addOtherConfig("username", username);
                finalOptions.addOtherConfig("password", password);
                break;
            }
            case "apikey": {
                String addTo = options.getOption("addTo");
                String key = options.getOption("key");
                String value = options.getOption("value");
                if (!API_TOKEN_ADD_TO_VALUES.contains(addTo)) {
                    throw new BadDatasourceException(String.format("Invalid datasource: addto value not allowed: %s", addTo));
                }
                if (key == null || value == null) {
                    throw new BadDatasourceException("Invalid datasource: apikey auth without credentials");
                }
                finalOptions.addOtherConfig("addTo", addTo);
                finalOptions.addOtherConfig("key", key);
                finalOptions.addOtherConfig("value", value);
                break;
            }
            case "bearer": {
                String token = options.getOption("token");
                if (token == null) {
                    throw new BadDatasourceException("Invalid datasource: the token is not valid");
                }
                finalOptions.addOtherConfig("token", token);
                break;
            }
            case "noauth": {
                break;
            }
            default: {
                throw new BadDatasourceException(String.format("Unsupported authentication type: %s", type));
            }
        }
        return finalOptions;
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        DatasourceModel newDs = this.generateBasicInfoFrom(dsDef);
        newDs.setType(options.getOption("type"));
        newDs.setProduct(PRODUCT_CR);
        DsOptionsModel finalOptions = this.generateOptions(options);
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", newDs.getId());
        tokenData.addOtherConfig("url", dsDef.getUrl());
        tokenData.addOtherConfig("options", finalOptions);
        tokenData.addOtherConfig("product", PRODUCT_CR);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    @Override
    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        super.validate(dsDef, datasources);
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (connector == null) {
                throw new DhUserException(400, "INVALID_INSTANCE", "Data source definition not supported");
            }
        }
        catch (DhUserException dhe) {
            throw dhe;
        }
        catch (Exception e) {
            log.error("Generic invalid data source exception", (Throwable)e);
            throw new DhUserException(400, "INVALID_INSTANCE", e.getMessage());
        }
    }
}

