/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DatasourcePermissionsControllerImpl
implements DatasourcePermissionsController {
    @Inject
    private DHUserService userService;
    @Inject
    private DatasourcesController dsController;

    @Override
    public boolean isUserAllowedToUse(DatasourceModel ds, String userKey) {
        return ds.getPrivate() == false || userKey != null && userKey.equals(ds.getCreator());
    }

    @Override
    public boolean isLoggedInUserAllowedToUse(DatasourceModel ds) {
        return this.isUserAllowedToUse(ds, this.userService.getLoggedInUserKey());
    }

    @Override
    public boolean isLoggedInUserAllowedToUse(String dsId) {
        try {
            DatasourceModel ds = this.dsController.getDatasource(dsId);
            return ds != null && this.isUserAllowedToUse(ds, this.userService.getLoggedInUserKey());
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

