/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.server.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetAllFiltersServerFunc {
    private static final Logger log = LoggerFactory.getLogger(GetAllFiltersServerFunc.class);
    public static final String PATH_FAV_FILTERS = "/rest/api/2/filter/favourite";
    public static final String PATH_GREENHOPPER_FILTERS = "/rest/greenhopper/1.0/savedfilter/list";
    private final ServerConnector connector;

    public GetAllFiltersServerFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public ResponseEntity<List> getAllFilters(Map<String, ?> params, Map<String, Object> options) {
        List<Map> favourites = this.getFavouriteFilters();
        List<Map> savedFilters = this.getSavedFilters(params);
        List<Map> allFilters = this.concatFilters(favourites, savedFilters);
        List<Map> finalList = this.filterByName(allFilters, params);
        return new ResponseEntity(finalList, HttpStatus.OK);
    }

    Map txFilter(Map rawFilter) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String id = rawFilter.get("id").toString();
        data.put("id", id);
        data.put("favourite", rawFilter.getOrDefault("favourite", false));
        data.put("name", rawFilter.get("name"));
        if (rawFilter.containsKey("jql")) {
            data.put("jql", rawFilter.get("jql"));
        } else {
            data.put("jql", rawFilter.get("query"));
        }
        if (data.containsKey("self")) {
            data.put("self", rawFilter.get("self"));
        } else {
            data.put("self", String.format("%s/rest/api/2/filter/%s", this.connector.getURL(), id));
        }
        return data;
    }

    List<Map> getFavouriteFilters() {
        ResponseEntity<List> response = this.connector.executeRequest(PATH_FAV_FILTERS, null, List.class);
        ResponseChecker.checkStatus(response);
        List filters = (List)response.getBody();
        return filters.stream().map(this::txFilter).collect(Collectors.toList());
    }

    List<Map> getSavedFilters(Map<String, ?> params) {
        try {
            ResponseEntity<String> response = this.connector.executeRequest(PATH_GREENHOPPER_FILTERS, params);
            boolean isHTMLResponse = ((String)response.getBody()).trim().startsWith("<!DOCTYPE html>");
            if (response.getStatusCodeValue() < 400 && !isHTMLResponse) {
                Map data = ResponseChecker.checkStatusAndParse(response, Map.class);
                List filters = (List)data.get("filters");
                return filters.stream().map(this::txFilter).collect(Collectors.toList());
            }
            log.warn("Saved filter is not present (greenhopper API). HTTP code -> " + response.getStatusCodeValue() + ". It is returning an HTML page -> " + isHTMLResponse);
        }
        catch (Exception e) {
            log.error("Problems getting saved filters from greenhopper Rest API", (Throwable)e);
        }
        return Collections.emptyList();
    }

    List<Map> concatFilters(List<Map> favourites, List<Map> savedFilters) {
        List favouriteIds = favourites.stream().map(fav -> (String)fav.get("id")).collect(Collectors.toList());
        List onlyNoFav = savedFilters.stream().filter(filter -> !favouriteIds.contains(filter.get("id").toString())).collect(Collectors.toList());
        return Stream.concat(favourites.stream(), onlyNoFav.stream()).collect(Collectors.toList());
    }

    List<Map> filterByName(List<Map> filters, Map<String, ?> params) {
        List finalList = filters;
        if (!filters.isEmpty() && params.containsKey("filterName")) {
            String filterName = (String)(params instanceof MultivaluedMap ? ((MultivaluedMap)params).getFirst((Object)"filterName") : params.get("filterName"));
            finalList = finalList.stream().filter(filter -> ((String)filter.get("name")).contains(filterName)).collect(Collectors.toList());
        }
        return finalList;
    }
}

