/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.BitbucketCountResultsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetCommitFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetPrInfoFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetProjectsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetPrsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetPullRequestsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetRepositoriesFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.SearchRepositoriesFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class BitbucketDatacenterConnectorImpl
implements BitbucketConnector {
    private static final Logger log = LoggerFactory.getLogger(BitbucketDatacenterConnectorImpl.class);
    private ServerConnector connector;

    public BitbucketDatacenterConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public String getProjectFromDs() {
        return this.connector.getProperty("projectKey", String.class);
    }

    @Override
    public boolean isValid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putIfAbsent("limit", "1");
        ResponseEntity<List> repos = this.searchRepositories(params, false);
        ResponseChecker.checkStatus(repos);
        return true;
    }

    @Override
    public ResponseEntity<Map> getUser(String projectKey, String userSlug) {
        String pathPattern = "/rest/api/1.0/users/%s?avatarSize=64";
        String path = String.format("/rest/api/1.0/users/%s?avatarSize=64", userSlug);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getWorkspaceMembers() {
        throw new RuntimeException("Method 'getWorkspaceMembers()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<Integer> countWorkspaceMembers() {
        log.warn("Method 'countWorkspaceMembers()' is not supported by BitbucketDatacenterConnector");
        return new ResponseEntity((Object)0, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List> getRepositories(String project, Map<String, String> params, boolean loadAll) {
        return new GetRepositoriesFunc(this.connector).exec(project, params, loadAll);
    }

    @Override
    public ResponseEntity<List> searchRepositories(Map<String, String> params, boolean loadAll) {
        ResponseEntity<Map> response;
        if (params.containsKey("slug") && (response = this.getRepository(params.get("project"), params.get("slug"))).getStatusCodeValue() < 400) {
            List<Map> repositories = Arrays.asList((Map)response.getBody());
            return new ResponseEntity(repositories, response.getStatusCode());
        }
        return new SearchRepositoriesFunc(this.connector).exec(params, loadAll);
    }

    @Override
    public ResponseEntity<Map> getRepository(String project, String repoSlug) {
        String actualProject = project == null || project.equals("") ? this.getProjectFromDs() : project;
        String path = String.format("/rest/api/1.0/projects/%s/repos/%s", actualProject, repoSlug);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getPrs(String project, String repoSlug) {
        return new GetPrsFunc(this.connector).exec(project, repoSlug);
    }

    @Override
    public ResponseEntity<Map> getPrInfo(Map pullRequest, List<String> expand) {
        return new GetPrInfoFunc(this.connector).exec(pullRequest, expand);
    }

    @Override
    public ResponseEntity<List> getPullRequests(String project, String repoSlug, Map<String, String> params, boolean loadAll) {
        return new GetPullRequestsFunc(this.connector).exec(project, repoSlug, params, loadAll);
    }

    @Override
    public ResponseEntity<Integer> countPullRequests(String project, String repoSlug, Map<String, String> params) {
        String path = String.format("/rest/api/1.0/projects/%s/repos/%s/pull-requests", project, repoSlug);
        return new BitbucketCountResultsFunc(this.connector).exec(path, params);
    }

    @Override
    public ResponseEntity<Map> getCommit(String project, String repoSlug, String hash) {
        return new GetCommitFunc(this.connector).exec(project, repoSlug, hash);
    }

    @Override
    public ResponseEntity<List> getPipelines(String repoSlug, Map<String, String> params) {
        throw new RuntimeException("Method 'getPipelines()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<Map> getPipeline(String repoSlug, String pipelineUuid) {
        throw new RuntimeException("Method 'getPipeline()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<List> getPipelineSteps(String repoSlug, String pipelineUuid, Map<String, String> options) {
        throw new RuntimeException("Method 'getPipelineSteps()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<List> getDeployments(String repoSlug, Map<String, String> options, boolean loadAll) {
        throw new RuntimeException("Method 'getDeployments()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<Map> getDeployment(String repoSlug, String deploymentUuid) {
        throw new RuntimeException("Method 'getDeployment()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<Map> getEnvironment(String repoSlug, String environmentUuid) {
        throw new RuntimeException("Method 'getEnvironment()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<List> getWorkspaces(Map<String, String> params, boolean loadAll) {
        throw new RuntimeException("Method 'getWorkspaces()' is not supported by BitbucketDatacenterConnector");
    }

    @Override
    public ResponseEntity<List> getProjects(Map<String, String> params, boolean loadAll) {
        return new GetProjectsFunc(this.connector).exec(params, loadAll);
    }

    @Override
    public ResponseEntity<String> getPipelineStepLog(String repoSlug, String pipelineUuid, String stepUuid) {
        throw new RuntimeException("Method 'getPipeline()' is not supported by BitbucketDatacenterConnector");
    }
}

