/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.APITokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.BearerTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.NoAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.customReports.CustomReportConnectorImpl;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class CustomReportsConnectorFactory
implements ConnectorFactory {
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private DatasourcesUtil datasourcesUtil;

    RestAuthStrategy getRestAuthStrategy(DatasourceModel ds) {
        DsOptionsModel dsOptions = this.datasourcesUtil.getSecretOptions(ds.getToken());
        Map options = dsOptions.getOption("options", HashMap.class);
        String type = (String)options.get("type");
        Class strategyClass = null;
        switch (type) {
            case "basic": {
                strategyClass = DatasourceBasicAuthStrategy.class;
                break;
            }
            case "bearer": {
                strategyClass = BearerTokenAuthStrategy.class;
                break;
            }
            case "apikey": {
                strategyClass = APITokenAuthStrategy.class;
                break;
            }
            case "noauth": {
                strategyClass = NoAuthStrategy.class;
                break;
            }
            default: {
                throw new BadDatasourceException(String.format("Unsupported datasource type: %s", type));
            }
        }
        return this.authStrategyFactory.getRestAuthStrategy(strategyClass, ds);
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy authStrategy = this.getRestAuthStrategy(ds);
        if (authStrategy == null) {
            throw new RuntimeException(String.format("Datasource not supported - %s/%s", ds.getId(), ds.getType()));
        }
        return new CustomReportConnectorImpl(this.serverConnectorFactory.getServerConnector(ds, authStrategy));
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return Product.CUSTOM_REPORTS.value().equals(ds.getProduct());
    }
}

