/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.confluence.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.controllers.impl.ConfluenceUsersControllerImpl;
import com.roninpixels.dashboardhub.web.rest.base.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.base.confluence.api.ConfluenceBulkGroupsRequest;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/confluence/v1/groups")
public class BulkGroupsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BulkGroupsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull ConfluenceBulkGroupsRequest request) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ConfluenceUsersControllerImpl confluenceUsersController = new ConfluenceUsersControllerImpl(confluence);
            return ResponseBuilder.ok(confluenceUsersController.getBulkGroups(request.getGroupNames(), request.getMaxResults())).build();
        }
        catch (Exception e) {
            return MessagesUtil.generateErrorResponse(500, "Error searching user groups");
        }
    }
}

