/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license;

import com.atlassian.plugin.Plugin;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LicenseInfoJsonBean {
    @JsonProperty
    private Map host;
    @JsonProperty
    private String installedDate;
    @JsonProperty
    private String key;
    @JsonProperty
    private String lastUpdated;
    @JsonProperty
    private Map license;
    @JsonProperty
    private String state;
    @JsonProperty
    private String version;

    public Map getHost() {
        return this.host;
    }

    public void setHost(Map host) {
        this.host = host;
    }

    public String getInstalledDate() {
        return this.installedDate;
    }

    public void setInstalledDate(String installedDate) {
        this.installedDate = installedDate;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Map getLicense() {
        return this.license;
    }

    public void setLicense(Map license) {
        this.license = license;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static LicenseInfoJsonBean shortBean(Plugin plugin, PluginLicense pluginLicense, String hostDisplayName) {
        if (plugin == null) {
            return null;
        }
        LicenseInfoJsonBean bean = new LicenseInfoJsonBean();
        bean.state = plugin.getPluginState().name();
        bean.version = plugin.getPluginInformation().getVersion();
        bean.installedDate = plugin.getDateInstalled().toInstant().toString();
        bean.key = plugin.getKey();
        HashMap<String, String> product = new HashMap<String, String>();
        product.put("product", hostDisplayName);
        bean.host = product;
        HashMap<String, Object> license = new HashMap<String, Object>();
        license.put("active", pluginLicense != null ? pluginLicense.isValid() : false);
        license.put("evaluation", pluginLicense != null ? pluginLicense.isEvaluation() : false);
        license.put("type", pluginLicense != null ? pluginLicense.getLicenseType().name() : LicenseType.DEVELOPER.name());
        bean.license = license;
        return bean;
    }
}

