/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DsLocal")
public class JiraConfluenceLocal
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(JiraConfluenceLocal.class);
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;
    private static final List<String> PRODUCTS = Arrays.asList(Product.JIRA.value(), Product.CONFLUENCE.value());

    @Override
    public boolean match(DatasourceModel ds) {
        return PRODUCTS.contains(ds.getProduct()) && ProductHosting.DIRECT.value().equals(ds.getType());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = dsDef.getId() != null ? dsDef.getId() : UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setType(ProductHosting.DIRECT.value());
        newDs.setUrl(dsDef.getUrl());
        newDs.setFirst(dsDef.getFirst());
        newDs.setProduct(dsDef.getProduct());
        newDs.setCreator(dsDef.getCreator());
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setCreated(new Date());
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", id);
        tokenData.addOtherConfig("url", newDs.getUrl());
        tokenData.addOtherConfig("type", newDs.getType());
        tokenData.addOtherConfig("product", newDs.getProduct());
        tokenData.addOtherConfig(dsDef.getType(), true);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            log.debug("DATASOURCE CREATION - BEFORE GET CONNECTOR");
            log.debug("DATASOURCE DATA---------------------------");
            log.debug("-----url:", (Object)dsDef.getUrl());
            log.debug("-----type:", (Object)dsDef.getType());
            log.debug("-----token:", (Object)dsDef.getToken());
            log.debug("-----creator:", (Object)dsDef.getCreator());
            log.debug("-----product:", (Object)dsDef.getProduct());
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            log.debug("DATASOURCE CREATION - AFTER GET CONNECTOR", (Object)connector.getURL());
            if (!connector.isValid()) {
                log.error(String.format("Invalid datasource -> %s // %s", dsDef.getProduct(), dsDef.getType()));
                throw new RuntimeException("INVALID_INSTANCE");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID_INSTANCE", e);
        }
    }
}

