/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.globals.DefaultFilter;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class ExecJQLFunc {
    private static final Logger log = LoggerFactory.getLogger(ExecJQLFunc.class);
    public static final int DEFAULT_PAGE_SIZE = 100;
    private final ServerConnector connector;
    private String path;
    private final int MAX_JQL;
    private final int PARALLEL_REQUESTS;

    public ExecJQLFunc(ServerConnector connector, JiraIntegrationProperties jiraProps, String path) {
        this.connector = connector;
        this.path = path;
        this.MAX_JQL = jiraProps.getMaxIssues();
        this.PARALLEL_REQUESTS = jiraProps.getParallelRequesters();
    }

    public boolean jqlIsAPredefinedFilter(String jql) {
        return jql.matches("filter\\s*=\\s*-[0-9]");
    }

    public Long getFilterId(String jql) {
        Pattern p = Pattern.compile("-[0-9]");
        Matcher m = p.matcher(jql);
        return m.find() ? Long.valueOf(Long.parseLong(m.group())) : null;
    }

    public String getJQLFromFilter(String originalJQL) {
        Long filterId = this.getFilterId(originalJQL);
        DefaultFilter filter = DefaultFilter.getById(filterId);
        return filter != null ? filter.getJql() : null;
    }

    public JQLResponse exec(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts) {
        String actualJql = this.jqlIsAPredefinedFilter(jql) ? this.getJQLFromFilter(jql) : jql;
        HashMap<String, Object> mParams = extraOpts != null ? new HashMap<String, Object>(extraOpts) : new HashMap();
        boolean loadAll = mParams.containsKey("loadAll") ? (Boolean)mParams.remove("loadAll") : true;
        int cnfLimit = loadAll ? this.MAX_JQL : ((Number)extraOpts.getOrDefault("maxResults", 100)).intValue();
        int limitIssues = Math.min(cnfLimit, this.MAX_JQL);
        int tmpPageSize = (Integer)mParams.getOrDefault("maxResults", 100);
        if (tmpPageSize < 0 || tmpPageSize > 100) {
            tmpPageSize = 100;
        }
        int pageSize = tmpPageSize;
        mParams.put("maxResults", pageSize);
        mParams.putIfAbsent("jql", actualJql);
        mParams.putIfAbsent("startAt", 0);
        if (fields != null) {
            mParams.putIfAbsent("fields", fields);
        }
        if (expand != null) {
            mParams.putIfAbsent("expand", expand);
        }
        if (properties != null) {
            mParams.putIfAbsent("properties", properties);
        }
        try {
            List issues = new LinkedList<Map>();
            ResponseEntity<JQLResponse> response = this.connector.executeRequest(Request.MethodType.POST, this.path, mParams, JQLResponse.class);
            ResponseChecker.checkStatus(response);
            JQLResponse jqlResponse = (JQLResponse)response.getBody();
            if (jqlResponse.getIssues().size() < limitIssues && jqlResponse.getTotal() > pageSize) {
                int pendingJobs = limitIssues / pageSize - 1;
                LinkedList<HashMap<String, Object>> jobs = new LinkedList<HashMap<String, Object>>();
                for (int i = 0; i < pendingJobs; ++i) {
                    HashMap<String, Object> localParams = new HashMap<String, Object>(mParams);
                    localParams.put("startAt", pageSize * (i + 1));
                    jobs.add(localParams);
                }
                ForkJoinPool customThreadPool = new ForkJoinPool(this.PARALLEL_REQUESTS);
                issues = (List)((ForkJoinTask)customThreadPool.submit(() -> jobs.parallelStream().map(localParams -> {
                    ResponseEntity<JQLResponse> localResponse = this.connector.executeRequest(Request.MethodType.POST, this.path, (Map<String, ?>)localParams, JQLResponse.class);
                    ResponseChecker.checkStatus(localResponse);
                    JQLResponse result = (JQLResponse)localResponse.getBody();
                    return result.getIssues();
                }).flatMap(localIssues -> localIssues.stream()).collect(Collectors.toList()))).get();
                customThreadPool.shutdown();
            }
            issues.addAll(0, jqlResponse.getIssues());
            return this.createJQLResponseForAllIssues(jqlResponse, issues);
        }
        catch (BadRequestToSourceException bre) {
            throw bre;
        }
        catch (Exception ex) {
            log.error("Bad data", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private JQLResponse createJQLResponseForAllIssues(JQLResponse firstPage, List<Map> issues) {
        JQLResponse jqlResponse = new JQLResponse();
        jqlResponse.setExpand(firstPage.getExpand());
        jqlResponse.setStartAt(0);
        jqlResponse.setMaxResults(issues.size());
        jqlResponse.setTotal(firstPage.getTotal());
        jqlResponse.setIssues(issues);
        jqlResponse.setNames(firstPage.getNames());
        jqlResponse.setWarningMessages(firstPage.getWarningMessages());
        return jqlResponse;
    }
}

