/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bigpicture;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.AvailableDataTypesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFieldDefinitionsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxHierarchyResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxIdsRequest;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxSelectedFieldsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxStatusesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxTypesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxesSelectedFieldsRequest;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.QueryObjectivesRequest;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.QueryObjectivesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsValuesCargo;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsValuesRequest;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsValuesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TasksInBoxesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TeamsAllocatedToBoxesResponse;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class BigPictureConnectorImpl
implements BigPictureConnector {
    private static final Logger log = LoggerFactory.getLogger(BigPictureConnectorImpl.class);
    public static final String PATH_SYSTEM_INFO = "/system-info";
    public static final String PATH_BOX_FIELD_DEFINITIONS = "/public/ppm/box/field/definition";
    public static final String PATH_BOX_SELECTED_FIELDS = "/public/ppm/box/selectedFields";
    public static final String PATH_BOX_HIERARCHY = "/public/ppm/box/box-hierarchy";
    public static final String PATH_BOX_TYPES = "/public/ppm/box/box-types";
    public static final String PATH_AVAILABLE_STATUS = "/public/ppm/box/boxes/statuses";
    public static final String PATH_AVAILABLE_DATA_TYPES = "/public/util/datatype/available";
    public static final String PATH_COLORS = "/util/lang/color";
    public static final String PATH_TASK_FIELD_DEFINITIONS = "/public/ppm/task/fields/available";
    public static final String PATH_TASK_FIELD_VALUES = "/public/ppm/task/core/task/field/bulk";
    public static final String PATH_TASK_IN_BOXES = "/public/ppm/boxarea/task/scope";
    public static final String PATH_TEAM_ALLOCATED_TO_BOXES = "/ppm/resource/teams/allocated-teams";
    public static final String PATH_QUERY_OBJECTIVES = "/ppm/objective/query";
    private DHObjectMapper mapper = new DHObjectMapperImpl();
    protected final ServerConnector connector;

    public BigPictureConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        try {
            Map systemInfoMap = this.getSystemInfo();
            return systemInfoMap.containsKey("systemVersion");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map getSystemInfo() {
        ResponseEntity<Map> res = this.connector.executeRequest(PATH_SYSTEM_INFO, null, Map.class);
        ResponseChecker.checkStatus(res);
        return (Map)res.getBody();
    }

    @Override
    public BoxFieldDefinitionsResponse getBoxFieldDefinitions() {
        ResponseEntity<BoxFieldDefinitionsResponse> res = this.connector.executeRequest(PATH_BOX_FIELD_DEFINITIONS, null, BoxFieldDefinitionsResponse.class);
        ResponseChecker.checkStatus(res);
        return (BoxFieldDefinitionsResponse)res.getBody();
    }

    @Override
    public BoxHierarchyResponse getBoxHierarchy() {
        ResponseEntity<BoxHierarchyResponse> res = this.connector.executeRequest(PATH_BOX_HIERARCHY, null, BoxHierarchyResponse.class);
        ResponseChecker.checkStatus(res);
        return (BoxHierarchyResponse)res.getBody();
    }

    @Override
    public BoxSelectedFieldsResponse getBoxSelectedFields(List<String> boxIds, Map<String, List<String>> fieldIds) throws IOException {
        BoxesSelectedFieldsRequest request = new BoxesSelectedFieldsRequest(boxIds, fieldIds);
        String requestBody = this.mapper.writeValueAsString(request);
        ResponseEntity<BoxSelectedFieldsResponse> res = this.connector.executeRequest(Request.MethodType.POST, PATH_BOX_SELECTED_FIELDS, null, null, requestBody, BoxSelectedFieldsResponse.class);
        BigPictureConnectorImpl.checkBoxHierarchyResponseStatus(res);
        return (BoxSelectedFieldsResponse)res.getBody();
    }

    private static void checkBoxHierarchyResponseStatus(ResponseEntity<BoxSelectedFieldsResponse> res) {
        int statusCode = res.getStatusCodeValue();
        if (statusCode >= HttpStatus.BAD_REQUEST.value()) {
            throw new BadRequestToSourceException(statusCode, "Error fetching box field values from BigPicture", res);
        }
    }

    @Override
    public BoxTypesResponse getBoxTypes() {
        ResponseEntity<BoxTypesResponse> res = this.connector.executeRequest(PATH_BOX_TYPES, null, BoxTypesResponse.class);
        ResponseChecker.checkStatus(res);
        return (BoxTypesResponse)res.getBody();
    }

    @Override
    public BoxStatusesResponse getAvailableStatus() {
        ResponseEntity<BoxStatusesResponse> res = this.connector.executeRequest(PATH_AVAILABLE_STATUS, null, BoxStatusesResponse.class);
        ResponseChecker.checkStatus(res);
        return (BoxStatusesResponse)res.getBody();
    }

    @Override
    public AvailableDataTypesResponse getAvailableDataTypes() {
        ResponseEntity<AvailableDataTypesResponse> res = this.connector.executeRequest(PATH_AVAILABLE_DATA_TYPES, null, AvailableDataTypesResponse.class);
        ResponseChecker.checkStatus(res);
        return (AvailableDataTypesResponse)res.getBody();
    }

    @Override
    public List getColors() {
        ResponseEntity<List> res = this.connector.executeRequest(PATH_COLORS, null, List.class);
        ResponseChecker.checkStatus(res);
        return (List)res.getBody();
    }

    @Override
    public TaskFieldsResponse getTaskFieldDefinitions() {
        ResponseEntity<TaskFieldsResponse> res = this.connector.executeRequest(PATH_TASK_FIELD_DEFINITIONS, null, TaskFieldsResponse.class);
        ResponseChecker.checkStatus(res);
        return (TaskFieldsResponse)res.getBody();
    }

    @Override
    public TaskFieldsValuesResponse getTaskFieldValues(List<String> taskIdOrExtPlatformTaskKeys, List<String> fieldNames) throws IOException {
        if (fieldNames == null || fieldNames.isEmpty() || taskIdOrExtPlatformTaskKeys == null || taskIdOrExtPlatformTaskKeys.isEmpty()) {
            throw new IllegalArgumentException("Required parameter taskIdOrExtPlatformTaskKeys or fieldNames was null or undefined when calling getTaskFieldValues.");
        }
        TaskFieldsValuesRequest request = new TaskFieldsValuesRequest(taskIdOrExtPlatformTaskKeys, fieldNames);
        ResponseEntity<TaskFieldsValuesResponse> res = this.connector.executeRequest(Request.MethodType.POST, PATH_TASK_FIELD_VALUES, null, null, this.mapper.writeValueAsString(request), TaskFieldsValuesResponse.class);
        BigPictureConnectorImpl.checkTaskFieldsValuesResponseStatus(res);
        return (TaskFieldsValuesResponse)res.getBody();
    }

    private static void checkTaskFieldsValuesResponseStatus(ResponseEntity<TaskFieldsValuesResponse> res) {
        int statusCode = res.getStatusCodeValue();
        if (statusCode >= HttpStatus.BAD_REQUEST.value()) {
            Optional.ofNullable((TaskFieldsValuesResponse)res.getBody()).map(TaskFieldsValuesResponse::getCargo).map(TaskFieldsValuesCargo::getErrorMessages).filter(errorMessages -> !errorMessages.isEmpty()).ifPresent(errorMessages -> {
                String errorMsg = String.join((CharSequence)". ", errorMessages);
                log.error("getTaskFieldValues Error (status {}): {}", (Object)statusCode, (Object)errorMsg);
                throw new BadRequestToSourceException(statusCode, errorMsg);
            });
            throw new BadRequestToSourceException(statusCode, "Error fetching tasks from BigPicture", res);
        }
    }

    @Override
    public TasksInBoxesResponse getTaskInBoxes(List<String> boxIds) throws IOException {
        if (boxIds == null || boxIds.isEmpty()) {
            throw new IllegalArgumentException("Required parameter boxIds was null or undefined when calling getTaskInBoxes.");
        }
        BoxIdsRequest request = new BoxIdsRequest(boxIds);
        ResponseEntity<TasksInBoxesResponse> res = this.connector.executeRequest(Request.MethodType.POST, PATH_TASK_IN_BOXES, null, null, this.mapper.writeValueAsString(request), TasksInBoxesResponse.class);
        ResponseChecker.checkStatus(res);
        return (TasksInBoxesResponse)res.getBody();
    }

    @Override
    public TeamsAllocatedToBoxesResponse getTeamsAllocatedToBoxes(List<String> boxIds) throws IOException {
        if (boxIds == null || boxIds.isEmpty()) {
            throw new IllegalArgumentException("Required parameter boxIds was null or undefined when calling getTeamsAllocatedToBoxes.");
        }
        BoxIdsRequest request = new BoxIdsRequest(boxIds);
        ResponseEntity<TeamsAllocatedToBoxesResponse> res = this.connector.executeRequest(Request.MethodType.POST, PATH_TEAM_ALLOCATED_TO_BOXES, null, null, this.mapper.writeValueAsString(request), TeamsAllocatedToBoxesResponse.class);
        ResponseChecker.checkStatus(res);
        return (TeamsAllocatedToBoxesResponse)res.getBody();
    }

    @Override
    public QueryObjectivesResponse getQueryObjectives(List<String> boxIds, List<String> teamIds) throws IOException {
        if (boxIds == null || boxIds.isEmpty() || teamIds == null || teamIds.isEmpty()) {
            throw new IllegalArgumentException("Required parameter boxIds or teamIds was null or undefined when calling getQueryObjectives.");
        }
        QueryObjectivesRequest request = new QueryObjectivesRequest(boxIds, teamIds);
        ResponseEntity<QueryObjectivesResponse> res = this.connector.executeRequest(Request.MethodType.POST, PATH_QUERY_OBJECTIVES, null, null, this.mapper.writeValueAsString(request), QueryObjectivesResponse.class);
        ResponseChecker.checkStatus(res);
        return (QueryObjectivesResponse)res.getBody();
    }
}

