/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.DatasourceInfo;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.utils.TokenGeneratorImpl;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConnectorsProviderImpl
implements ConnectorsProvider {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsProviderImpl.class);
    private static final String TAG_DATASOURCE = "datasource";
    private static final String TAG_BOARD = "board";
    private static final String TAG_GADGET = "gadget";
    @Inject
    private ConnectorsFactory factory;
    @Inject
    private GadgetsRequesterController grController;
    @Inject
    private DatasourcesControllerV2 dsController;
    @Inject
    private DatasourcePermissionsController dsPermissionsController;
    @Inject
    private TokenGeneratorImpl tokenGenerator;
    @Inject
    private GadgetModelsFactory gadgetModelsFactory;
    @Inject
    private DHObjectMapper mapper;

    @Override
    public DHConnector getConnector(DatasourceModel datasource) {
        return this.factory.getConnector(datasource);
    }

    @Override
    public DHConnector getConnectorFromEncryptedDs(String datasourceInfo) {
        try {
            DatasourceModel ds = this.getDatasourceFrom(datasourceInfo);
            return this.getConnector(ds);
        }
        catch (Exception e) {
            throw new BadDatasourceException(datasourceInfo, e);
        }
    }

    @Override
    public DatasourceModel getDatasourceFrom(String datasourceInfo) throws Exception {
        DatasourceModel datasourceModel = null;
        String rawInfo = new String(Base64.getDecoder().decode(datasourceInfo));
        Map dsInfoUnknown = this.mapper.readValue(rawInfo, Map.class);
        if (dsInfoUnknown.containsKey(TAG_BOARD)) {
            DatasourceInfo dsInfo = this.mapper.convertValue((Object)dsInfoUnknown, DatasourceInfo.class);
            GadgetRequestModel grm = new GadgetRequestModel();
            grm.setBoardToken(dsInfo.getBoard());
            grm.setGadgetId(dsInfo.getGadget().getId());
            grm.setSlideIndex(dsInfo.getGadget().getSlide());
            grm.setGadgetIndex(dsInfo.getGadget().getIndex());
            GadgetModel gadget = this.grController.findGadgetWithDatasource(grm);
            datasourceModel = gadget.getConfig().getDatasource();
        } else if (dsInfoUnknown.containsKey(TAG_DATASOURCE)) {
            DatasourceModel ds = this.mapper.convertValue(dsInfoUnknown.get(TAG_DATASOURCE), DatasourceModel.class);
            datasourceModel = this.dsController.getDatasource(ds.getId());
        } else if (dsInfoUnknown.containsKey(TAG_GADGET)) {
            String token = (String)this.mapper.convertValue(dsInfoUnknown.get(TAG_GADGET), HashMap.class).get("token");
            TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(token);
            GadgetModel gadget = this.gadgetModelsFactory.getGadgetByToken(tokenContent);
            datasourceModel = this.dsController.getDatasource(gadget.getConfig().getDatasource().getId());
        } else {
            log.error("Datasource definition not supported: " + rawInfo);
        }
        if (datasourceModel != null) {
            this.dsPermissionsController.isLoggedInUserAllowedToUse(datasourceModel);
        }
        return datasourceModel;
    }
}

