/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.models.ResponseDataModel;
import com.roninpixels.dashboardhub.web.rest.base.EndpointUtilities;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jira/v1/queues")
public class QueuesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(QueuesEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @Path(value="/{serviceDeskId}")
    @Produces(value={"application/json"})
    public Response getAllByServiceDeskId(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="serviceDeskId") String serviceDeskId, @Context UriInfo ui) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            MultivaluedMap params = ui.getQueryParameters();
            List<Map> queues = jira.getQueues(serviceDeskId, (Map<String, ?>)params);
            ResponseDataModel<Map> responseData = new ResponseDataModel<Map>(queues);
            return EndpointUtilities.generateResponse(responseData);
        }
        catch (BadRequestToSourceException bse) {
            log.error("Problems getting queues for serviceDeskId: " + serviceDeskId, (Throwable)bse);
            return EndpointUtilities.generateResponse(bse);
        }
        catch (Exception e) {
            log.error("Problems getting queues for serviceDeskId: " + serviceDeskId, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

