/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class PriorityEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PriorityEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    public Response getStatus(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> res = jira.getPriorities();
            return GenericJiraEndpoint.generateResponse(res, "priorities");
        }
        catch (Exception e) {
            log.error("Problems getting priority values", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

