/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management;

import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management.AccessMngMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessManagementEndpoint {
    private static final Logger log = LoggerFactory.getLogger(AccessManagementEndpoint.class);
    @Inject
    private AccessManagementController accessManagementController;
    @Inject
    private DHUserService dhUserService;

    public Response setAccessConfiguration(AccessMngMessageModel message) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            AppConfigModel appConfig = new AppConfigModel();
            appConfig.setAppRestricted(message.getAppRestricted());
            appConfig.setCustomerPortal(message.getCustomerPortal());
            appConfig.setAppAllowedUserGroups(message.getAppAllowedUserGroups());
            appConfig.setPublicLinkSettings(message.getPublicLinkSettings());
            appConfig.setLinksPolicy(message.getLinksPolicy());
            this.accessManagementController.updateConfig(appConfig);
            HashMap<String, Boolean> responseData = new HashMap<String, Boolean>();
            responseData.put("ok", true);
            return ResponseBuilder.ok(responseData).build();
        }
        catch (Exception e) {
            log.error("Problems updating the access configuration", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

