/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.gadgetsRequester;

import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHSessionHandler;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.gadgetsRequester.GadgetsRequestEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GadgetsRequestEndpointWrapper {
    private static final Logger log = LoggerFactory.getLogger(GadgetsRequestEndpointWrapper.class);
    @Inject
    private GadgetsRequestEndpoint gadgetsRequestEndpoint;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private DHSessionHandler dhSessionHandler;

    public Response doRequest(@HeaderParam(value="Dhsession") String dhSessionToken, @HeaderParam(value="Dhpublicsession") String dhPublicToken, String gadgetRequestRaw) {
        GadgetRequestModel gadgetRequest = null;
        try {
            gadgetRequest = this.mapper.readValue(gadgetRequestRaw, GadgetRequestModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        HashMap<String, Object> sessionHeaders = new HashMap();
        try {
            sessionHeaders = this.dhSessionHandler.validateDhSession(dhSessionToken, dhPublicToken, gadgetRequest);
        }
        catch (Exception e) {
            return ResponseBuilder.create(401).build();
        }
        Response resp = this.gadgetsRequestEndpoint.doRequest(gadgetRequest);
        return ResponseBuilder.create(resp, sessionHeaders);
    }
}

