/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.roninpixels.dashboardhub.services.DHSessionHandler;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.net.URL;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequesterProxyEndpoint {
    @Inject
    private DHSessionHandler dhSessionHandler;
    private static final Logger log = LoggerFactory.getLogger(RequesterProxyEndpoint.class);

    private static final String getExpirationTime() {
        return ZonedDateTime.now().plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public Response proxyGet(HttpServletRequest req, String dhSession) {
        try {
            this.dhSessionHandler.validateDhSession(dhSession);
        }
        catch (Exception e) {
            return ResponseBuilder.create(401).build();
        }
        String url = req.getParameter("url");
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.connect();
            return ResponseBuilder.ok(connection.getInputStream()).header("Expires", (Object)RequesterProxyEndpoint.getExpirationTime()).build();
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Throwable)e);
            return Response.status((int)404).header("Expires", (Object)RequesterProxyEndpoint.getExpirationTime()).build();
        }
    }
}

