/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.roninpixels.dashboardhub.gadgetsRequesters.CustomReportsGadgetRequestService;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHSessionHandler;
import com.roninpixels.dashboardhub.services.PublicLinkSessionService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;

public class CRGadgetRequesterEndpoint {
    @Inject
    private CustomReportsGadgetRequestService gadgetsRequestEndpoint;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private DHSessionHandler dhSessionHandler;
    @Inject
    private PublicLinkSessionService publicLinkSessionHandlerService;

    public Response doRequest(@HeaderParam(value="Dhsession") String dhSessionToken, @HeaderParam(value="Dhpublicsession") String dhPublicToken, String gadgetRequestRaw) {
        CustomReportsGadgetRequestModel gadgetRequest = null;
        try {
            gadgetRequest = this.mapper.readValue(gadgetRequestRaw, CustomReportsGadgetRequestModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        HashMap<String, Object> sessionHeaders = new HashMap();
        try {
            sessionHeaders = this.dhSessionHandler.validateDhSession(dhSessionToken, dhPublicToken, gadgetRequest);
        }
        catch (Exception e) {
            return ResponseBuilder.create(401).build();
        }
        Response resp = this.gadgetsRequestEndpoint.doRequest(gadgetRequest);
        return ResponseBuilder.create(resp, sessionHeaders);
    }
}

