/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.atlassianInsight.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.AtlassianInsightConnector;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.rest.base.atlassianInsight.api.SearchWorkspacesRequest;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/atlassian-insight/v1/workspaces")
public class WorkspacesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WorkspacesEndpoint.class);
    @Inject
    private DatasourcesUtil dsUtil;
    @Inject
    private Crypto cryptoTool;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;

    DatasourceModel generateTemporalDatasource(String url, String username, String password) {
        DatasourceModel ds = new DatasourceModel();
        ds.setName("atlassian insight temporal");
        ds.setUrl(url);
        ds.setProduct(Product.INSIGHT.value());
        DsOptionsModel dsOptions = new DsOptionsModel();
        dsOptions.addOtherConfig("hostType", "cloud");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("username", username);
        options.put("password", password);
        dsOptions.addOtherConfig("options", options);
        ds.setOptions(dsOptions);
        return this.dsUtil.generateTemporal(ds, dsOptions);
    }

    @POST
    @Produces(value={"application/json"})
    public Response searchWorkspaces(SearchWorkspacesRequest request) {
        try {
            String rawData = this.cryptoTool.decryptFrontend(request.getEncrypted());
            Map data = this.mapper.readValue(rawData, Map.class);
            String url = (String)data.get("url");
            String user = (String)data.get("username");
            String pass = (String)data.get("password");
            DatasourceModel ds = this.generateTemporalDatasource(url, user, pass);
            AtlassianInsightConnector connector = (AtlassianInsightConnector)this.connectorsFactory.getConnector(ds);
            ResponseEntity<String> response = connector.getWorkspaces();
            int status = response.getStatusCodeValue();
            if (status < 400) {
                return Response.status((int)status).entity(response.getBody()).build();
            }
            if (status == 403) {
                return Response.status((int)403).build();
            }
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            log.error("Problems searching Assets workspaces", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

