/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.atlassianV1.dashboardHub.boards;

import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.BoardEndpoint;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.ChangeOwnerMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2/board/admin")
public class AdminBoardEndpointWrapperAtlasV1 {
    private static final Logger log = LoggerFactory.getLogger(AdminBoardEndpointWrapperAtlasV1.class);
    @Inject
    private BoardEndpoint boardEndpoint;
    @Inject
    private DHObjectMapper mapper;

    @GET
    @Path(value="/all")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFullBoards() {
        return this.boardEndpoint.getAllBoards();
    }

    @POST
    @Path(value="/changeOwner")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeOwner(String message) {
        ChangeOwnerMessageModel changeOwnerMessageModel = null;
        try {
            changeOwnerMessageModel = this.mapper.readValue(message, ChangeOwnerMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.boardEndpoint.changeOwner(changeOwnerMessageModel);
    }

    @PUT
    @Path(value="/disablePublicLink/{boardId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response disablePublicLink(@NotNull @PathParam(value="boardId") String boardId) {
        return this.boardEndpoint.disablePublicLink(boardId);
    }
}

