/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.images;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class ImageUtil {
    private static final Set<String> SUPPORTED_IMAGE_TYPES = new HashSet<String>();
    private static final Tika TIKA;

    public static String getImageMimeType(byte[] buffer) throws IOException, MimeTypeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
        String mimeType = TIKA.detect(inputStream);
        String extension = MimeTypes.getDefaultMimeTypes().forName(mimeType).getExtension().substring(1);
        return SUPPORTED_IMAGE_TYPES.contains(extension) ? mimeType : null;
    }

    static {
        SUPPORTED_IMAGE_TYPES.add("svg");
        SUPPORTED_IMAGE_TYPES.add("jpg");
        SUPPORTED_IMAGE_TYPES.add("jpeg");
        SUPPORTED_IMAGE_TYPES.add("png");
        SUPPORTED_IMAGE_TYPES.add("gif");
        SUPPORTED_IMAGE_TYPES.add("webp");
        SUPPORTED_IMAGE_TYPES.add("flif");
        SUPPORTED_IMAGE_TYPES.add("cr2");
        SUPPORTED_IMAGE_TYPES.add("tif");
        SUPPORTED_IMAGE_TYPES.add("tiff");
        SUPPORTED_IMAGE_TYPES.add("bmp");
        SUPPORTED_IMAGE_TYPES.add("jxr");
        SUPPORTED_IMAGE_TYPES.add("psd");
        SUPPORTED_IMAGE_TYPES.add("ico");
        SUPPORTED_IMAGE_TYPES.add("bpg");
        SUPPORTED_IMAGE_TYPES.add("jp2");
        SUPPORTED_IMAGE_TYPES.add("jpm");
        SUPPORTED_IMAGE_TYPES.add("jpx");
        SUPPORTED_IMAGE_TYPES.add("heic");
        SUPPORTED_IMAGE_TYPES.add("cur");
        SUPPORTED_IMAGE_TYPES.add("dcm");
        SUPPORTED_IMAGE_TYPES.add("avif");
        TIKA = new Tika();
    }
}

