/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.filter;

import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilterUtils {
    public static final List<String> PRODUCT_COMPAT = Arrays.asList(Product.JIRA.value());
    public static final boolean ONLY_CURRENT_INSTANCE = true;
    public static final List<String> USER_FILTER_FIELDS = Arrays.asList("assignee", "project", "status", "issuetype", "summary", "reporter", "duedate", "created", "resolutiondate", "updated", "components", "labels");

    public static List<String> getDatasourceCompatIds(List<DatasourceModel> datasources) {
        ArrayList<String> datasourceCompatIds = new ArrayList<String>();
        if (datasources != null) {
            datasources.stream().forEach(ds -> {
                if (PRODUCT_COMPAT.contains(ds.getProduct()) && ds.getType().equalsIgnoreCase(ProductHosting.DIRECT.value())) {
                    datasourceCompatIds.add(ds.getId());
                }
            });
        }
        return datasourceCompatIds;
    }
}

