/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.impl;

import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.exceptions.DHValidationException;
import com.roninpixels.dashboardhub.services.PublicLinkSessionService;
import com.roninpixels.dashboardhub.services.impl.PublicLinkSessionData;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class PublicLinkSessionServiceImpl
implements PublicLinkSessionService {
    private static final long SESSION_TIME_LIFE = 1800000L;
    @Inject
    private Crypto mCrypto;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private DHObjectMapper dhObjectMapper;
    @Inject
    private BoardsController boardsController;

    private long getNextExpirationTime(long currentET) {
        return currentET + 1800000L;
    }

    private String serialize(PublicLinkSessionData session) {
        try {
            String serializedSession = this.dhObjectMapper.writeValueAsString(session);
            return this.mCrypto.encryptBackend(serializedSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String generateToken(String boardId, String password) {
        PublicLinkSessionData session = new PublicLinkSessionData();
        session.setExternal(true);
        session.setBoardToken(boardId);
        session.setPassword(password);
        session.setExpirationTime(this.getNextExpirationTime(System.currentTimeMillis()));
        return this.serialize(session);
    }

    @Override
    public String validateToken(BoardModel board, String dhPublicToken) throws DHValidationException {
        block8: {
            try {
                if (board.getSharing() == null || board.getSharing().getPublic() != Boolean.TRUE) {
                    throw new DHValidationException("INVALID_BOARD");
                }
                if (dhPublicToken == null) {
                    if (board.getSharing().getPassword() != null) {
                        throw new DHValidationException("NOT_CREDENTIALS");
                    }
                    break block8;
                }
                String serializedSession = this.mCrypto.decryptBackend(dhPublicToken);
                PublicLinkSessionData session = this.dhObjectMapper.readValue(serializedSession, PublicLinkSessionData.class);
                if (session.getExpirationTime() < System.currentTimeMillis()) {
                    throw new DHValidationException("SESSION_EXPIRED");
                }
                if (!board.getToken().equals(session.getBoardToken()) || !this.mCrypto.isHashValid(board.getSharing().getPassword(), session.getPassword())) {
                    throw new DHValidationException("INVALID_CREDENTIALS");
                }
                session.setExpirationTime(this.getNextExpirationTime(System.currentTimeMillis()));
                return this.serialize(session);
            }
            catch (DHValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public String validateToken(String boardToken, String dhPublicToken) throws DHValidationException {
        try {
            TokenContentModel boardTokenData = this.tokenGenerator.getTokenContent(boardToken);
            BoardModel storedBoard = this.boardsController.getBoard(boardTokenData.getBoardId());
            return this.validateToken(storedBoard, dhPublicToken);
        }
        catch (DHValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

