/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.impl;

import com.roninpixels.dashboardhub.controllers.providers.ProjectsProvider;
import com.roninpixels.dashboardhub.services.ProjectService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectServiceImpl
implements ProjectService {
    @Autowired(required=false)
    private Provider<ProjectsProvider> projectsProvider;

    private Collection<Map> getProjectsFor(String userKey) {
        if (this.projectsProvider.get() != null) {
            return ((ProjectsProvider)this.projectsProvider.get()).getProjectsFor(userKey).stream().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Map> getProjectsFor(String userKey, List<String> projectKeys) {
        if (this.projectsProvider.get() != null) {
            return ((ProjectsProvider)this.projectsProvider.get()).getProjectsFor(userKey, projectKeys).stream().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getProjectKeysFor(String userKey) {
        return this.getProjectsFor(userKey).stream().map(project -> (String)project.get("key")).collect(Collectors.toList());
    }
}

