/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.impl;

import com.roninpixels.dashboardhub.exceptions.DHValidationException;
import com.roninpixels.dashboardhub.services.DHSessionService;
import com.roninpixels.dashboardhub.services.impl.DHSession;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import java.nio.charset.Charset;
import java.util.Random;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DHSessionServiceImpl
implements DHSessionService {
    public static final long SESSION_TIME_LIFE = 1800000L;
    @Inject
    private Crypto mCrypto;
    @Inject
    private DHObjectMapper dhObjectMapper;

    public static String generateRandomString(int length) {
        byte[] array = new byte[length];
        new Random().nextBytes(array);
        String generatedString = new String(array, Charset.forName("UTF-8"));
        return generatedString;
    }

    private long getNextExpirationTime(long currentET) {
        return currentET + 1800000L;
    }

    private String serialize(DHSession session) {
        try {
            String serializedSession = this.dhObjectMapper.writeValueAsString(session);
            return this.mCrypto.encryptBackend(serializedSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DHSession deserialize(String token) {
        try {
            String serializedSession = this.mCrypto.decryptBackend(token);
            DHSession session = this.dhObjectMapper.readValue(serializedSession, DHSession.class);
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DHSession internalGenerateToken(boolean isExternal) {
        DHSession session = new DHSession();
        session.setExternal(isExternal);
        session.setExpirationTime(this.getNextExpirationTime(System.currentTimeMillis()));
        session.setPadding(DHSessionServiceImpl.generateRandomString(120));
        return session;
    }

    @Override
    public String generateToken(boolean isExternal) {
        return this.serialize(this.internalGenerateToken(isExternal));
    }

    @Override
    public String renovate(DHSession session) {
        return this.generateToken(session.isExternal());
    }

    @Override
    public String renovate(String sessionToken) {
        DHSession session = this.deserialize(sessionToken);
        return this.generateToken(session.isExternal());
    }

    @Override
    public DHSession validateToken(String token) throws DHValidationException {
        DHSession session = this.deserialize(token);
        if (session.getExpirationTime() < System.currentTimeMillis()) {
            throw new DHValidationException("SESSION_EXPIRED");
        }
        return session;
    }
}

