/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.impl;

import com.roninpixels.dashboardhub.exceptions.DHValidationException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHSessionHandler;
import com.roninpixels.dashboardhub.services.DHSessionService;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.PublicLinkSessionService;
import com.roninpixels.dashboardhub.services.impl.DHSession;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DHSessionHandlerImpl
implements DHSessionHandler {
    @Inject
    private DHSessionService dhSessionService;
    @Inject
    private PublicLinkSessionService publicLinkSessionHandlerService;
    @Inject
    private DHUserService dhUserService;

    @Override
    public Map<String, Object> validateDhSession(String dhSessionToken) throws DHValidationException {
        return this.validateDhSession(dhSessionToken, null, null);
    }

    @Override
    public Map<String, Object> validateDhSession(String dhSessionToken, String dhPublicSessionToken, GadgetRequestModel gadgetRequest) throws DHValidationException {
        boolean isLoggedInUser;
        HashMap<String, Object> sessionHeaders = new HashMap<String, Object>();
        boolean bl = isLoggedInUser = this.dhUserService.getLoggedInUser() != null;
        if (!isLoggedInUser) {
            DHSession session = this.dhSessionService.validateToken(dhSessionToken);
            sessionHeaders.put("dhsession", this.dhSessionService.renovate(session));
            if (session.isExternal()) {
                String newDHPublicSession = this.publicLinkSessionHandlerService.validateToken(gadgetRequest.getBoardToken(), dhPublicSessionToken);
                sessionHeaders.put("dhpublicsession", newDHPublicSession);
            }
        } else if (dhPublicSessionToken != null) {
            sessionHeaders.put("dhsession", this.dhSessionService.generateToken(true));
            String newDHPublicSession = this.publicLinkSessionHandlerService.validateToken(gadgetRequest.getBoardToken(), dhPublicSessionToken);
            sessionHeaders.put("dhpublicsession", newDHPublicSession);
        }
        return sessionHeaders;
    }
}

