/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.ViewPermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="SOME_VIEW_SOME_EDIT_USERS")
public class SomeCanEditViewForUsersRule
implements ViewPermission,
EditPermission {
    public static final String PERMISSION_TYPE = "SOME_VIEW_SOME_EDIT_USERS";
    @Inject
    private DHUserService dhUserService;

    @Override
    public boolean evaluateView(BoardModel board) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getBoardRestrictionsConfig(board.getRestrictions());
        return currentUser.equals(board.getOwner()) || this.dhUserService.isLoggedUserAdmin() != false || config.canViewUser(currentUser) || this.evaluateEdit(board);
    }

    @Override
    public boolean evaluateEdit(BoardModel board) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getBoardRestrictionsConfig(board.getRestrictions());
        return currentUser.equals(board.getOwner()) || this.dhUserService.isLoggedUserAdmin() != false || config.canEditUser(currentUser);
    }
}

