/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.ViewPermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="SOME_VIEW_SOME_EDIT_GROUPS")
public class SomeCanEditViewForGroupsRule
implements ViewPermission,
EditPermission {
    public static final String PERMISSION_TYPE = "SOME_VIEW_SOME_EDIT_GROUPS";
    @Inject
    private DHUserService dhUserService;

    @Override
    public boolean evaluateView(BoardModel board) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getBoardRestrictionsConfig(board.getRestrictions());
        Collection<String> groups = this.dhUserService.getGroupNamesFor(currentUser);
        return groups.stream().anyMatch(config::canViewGroup) || this.evaluateEdit(board);
    }

    @Override
    public boolean evaluateEdit(BoardModel board) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getBoardRestrictionsConfig(board.getRestrictions());
        Collection<String> groups = this.dhUserService.getGroupNamesFor(currentUser);
        return groups.stream().anyMatch(config::canEditGroup);
    }
}

