/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JQLSearch;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeInStatus
extends JQLSearch {
    private static final Logger log = LoggerFactory.getLogger(TimeInStatus.class);
    private static final List<String> EXTRA_EXPAND = Arrays.asList("changelog");
    private static final List<String> CHANGELOG_FIELDS = Arrays.asList("status", "assignee");

    public TimeInStatus() {
        super(EXTRA_EXPAND);
    }

    void ensureChangelogAreCompleted(Map<String, Object> data) {
        List issues = (List)data.get("issues");
        issues.parallelStream().forEach(issue -> {
            int total;
            String issueId = (String)issue.get("id");
            Map changelog = (Map)issue.get("changelog");
            int maxResults = (Integer)changelog.get("maxResults");
            if (maxResults != (total = ((Integer)changelog.get("total")).intValue())) {
                try {
                    Map newChangeLog = this.jiraConnector.getIssueChangelog(Long.parseLong(issueId));
                    issue.put("changelog", newChangeLog);
                }
                catch (Exception e) {
                    log.warn("Problems getting the whole changelog of the issue: " + issueId, (Throwable)e);
                }
            }
        });
    }

    Map loadMissingUserData(List<Map> issues) {
        HashSet<String> inChangelog = new HashSet<String>();
        HashMap<String, Map> assigneesAndReporters = new HashMap<String, Map>();
        for (Map issue : issues) {
            try {
                Map reporter;
                Map fields = (Map)issue.get("fields");
                Map assignee = (Map)fields.get("assignee");
                if (assignee != null) {
                    assigneesAndReporters.put(this.getUserId(assignee), assignee);
                }
                if ((reporter = (Map)fields.get("reporter")) != null) {
                    assigneesAndReporters.put(this.getUserId(reporter), reporter);
                }
                List histories = (List)((Map)issue.get("changelog")).get("histories");
                for (Map history : histories) {
                    List items = (List)history.get("items");
                    for (Map item : items) {
                        if (!"assignee".equals(item.get("field"))) continue;
                        inChangelog.add((String)item.get("from"));
                        inChangelog.add((String)item.get("to"));
                    }
                }
            }
            catch (Exception e) {
                log.warn("Problems getting the whole changelog of the issue: " + (issue == null ? "null" : issue.get("id")), (Throwable)e);
            }
        }
        HashMap users = new HashMap();
        HashSet<String> missing = new HashSet<String>();
        for (String userKey : inChangelog) {
            if (assigneesAndReporters.containsKey(userKey)) {
                users.put(userKey, assigneesAndReporters.get(userKey));
                continue;
            }
            if (userKey == null || "".equals(userKey)) continue;
            missing.add(userKey);
        }
        if (missing.size() > 0) {
            List requestedUsers = this.jiraConnector.bulkGetUsers(missing);
            for (Map user : requestedUsers) {
                users.put(this.getUserId(user), user);
            }
        }
        return users;
    }

    private String getUserId(Map<String, String> user) {
        String key = user.get("key");
        return key != null ? key : user.get("accountId");
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        Map data = (Map)super.getData(gadget, extraParams);
        this.ensureChangelogAreCompleted(data);
        JiraDataUtils.reduceHistory((List)data.get("issues"), CHANGELOG_FIELDS);
        Map users = this.loadMissingUserData((List)data.get("issues"));
        data.put("users", users);
        return data;
    }
}

