/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils;

import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskBoxFieldValues;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils.CommonUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TasksFilterUtils {
    public static final String KEY_BY_TASK_SEARCH_TERM = "BY_SEARCH_TERM";
    public static final String KEY_BY_TASK_STATUS = "BY_STATUS";
    public static final String KEY_BY_TASK_ASSIGNEE = "BY_ASSIGNEE";
    public static final String KEY_BY_TASK_DATE_RANGE = "BY_DATE_RANGE";

    public static List<TaskBoxFieldValues> getFilteredTasks(List<TaskBoxFieldValues> allTasks, Map<String, Object> taskFilters, List<Map> taskFields) {
        return allTasks.stream().filter(task -> TasksFilterUtils.filterBySearchTermTask(task, taskFilters, taskFields)).filter(task -> TasksFilterUtils.filterByAssigneeTask(task, taskFilters, taskFields)).filter(task -> TasksFilterUtils.filterByStatusTask(task, taskFilters, taskFields)).filter(task -> TasksFilterUtils.filterByDateRangeTask(task, taskFilters, taskFields)).collect(Collectors.toList());
    }

    private static boolean filterByDateRangeTask(TaskBoxFieldValues task, Map<String, Object> taskFilters, List<Map> taskFields) {
        if (!taskFilters.containsKey(KEY_BY_TASK_DATE_RANGE)) {
            return true;
        }
        Map dateRange = (Map)taskFilters.get(KEY_BY_TASK_DATE_RANGE);
        if (dateRange == null || CommonUtils.isEmpty((String)dateRange.get("minStartDate")) && CommonUtils.isEmpty((String)dateRange.get("maxEndDate"))) {
            return true;
        }
        String startDateId = TasksFilterUtils.getFieldIdByName(taskFields, "startDate").orElse(null);
        String endDateId = TasksFilterUtils.getFieldIdByName(taskFields, "endDate").orElse(null);
        if (startDateId == null || endDateId == null) {
            return false;
        }
        Date filterStartDate = CommonUtils.parseDate((String)dateRange.get("minStartDate"));
        Date filterEndDate = CommonUtils.parseDate((String)dateRange.get("maxEndDate"));
        String startDateValue = TasksFilterUtils.getTaskFieldValue(task, startDateId, "value");
        String endDateValue = TasksFilterUtils.getTaskFieldValue(task, endDateId, "value");
        Date taskStartDate = CommonUtils.parseDate(startDateValue);
        Date taskEndDate = CommonUtils.parseDate(endDateValue);
        boolean matchesStartDate = filterStartDate == null || taskStartDate != null && !taskStartDate.before(filterStartDate);
        boolean matchesEndDate = filterEndDate == null || taskEndDate != null && !taskEndDate.after(filterEndDate);
        return matchesStartDate && matchesEndDate;
    }

    private static boolean filterByStatusTask(TaskBoxFieldValues task, Map<String, Object> taskFilters, List<Map> taskFields) {
        if (!taskFilters.containsKey(KEY_BY_TASK_STATUS)) {
            return true;
        }
        String statusId = TasksFilterUtils.getFieldIdByName(taskFields, "status").orElse(null);
        if (statusId == null) {
            return false;
        }
        List statuses = Optional.ofNullable((List)taskFilters.get(KEY_BY_TASK_STATUS)).orElse(Collections.emptyList()).stream().map(String::toLowerCase).collect(Collectors.toList());
        if (statuses.isEmpty()) {
            return true;
        }
        String statusTaskValue = TasksFilterUtils.getTaskFieldValue(task, statusId, "id").toLowerCase();
        return statuses.contains(statusTaskValue);
    }

    private static boolean filterByAssigneeTask(TaskBoxFieldValues task, Map<String, Object> taskFilters, List<Map> taskFields) {
        if (!taskFilters.containsKey(KEY_BY_TASK_ASSIGNEE)) {
            return true;
        }
        String assigneeId = TasksFilterUtils.getFieldIdByName(taskFields, "assignee").orElse(null);
        if (assigneeId == null) {
            return false;
        }
        List assignees = (List)taskFilters.get(KEY_BY_TASK_ASSIGNEE);
        if (assignees.isEmpty()) {
            return true;
        }
        String assigneeTaskValue = TasksFilterUtils.getTaskFieldValue(task, assigneeId, "id");
        return assignees.contains(assigneeTaskValue.equals("") ? null : assigneeTaskValue);
    }

    private static boolean filterBySearchTermTask(TaskBoxFieldValues task, Map<String, Object> taskFilters, List<Map> taskFields) {
        if (!taskFilters.containsKey(KEY_BY_TASK_SEARCH_TERM)) {
            return true;
        }
        String searchTerm = ((String)taskFilters.get(KEY_BY_TASK_SEARCH_TERM)).trim().toLowerCase();
        if (searchTerm.isEmpty()) {
            return true;
        }
        String summaryId = TasksFilterUtils.getFieldIdByName(taskFields, "summary").orElse(null);
        String keyId = TasksFilterUtils.getFieldIdByName(taskFields, "key").orElse(null);
        if (summaryId == null && keyId == null) {
            return false;
        }
        String summaryValue = TasksFilterUtils.getTaskFieldValue(task, summaryId, "summary").toLowerCase();
        String keyValue = TasksFilterUtils.getTaskFieldValue(task, keyId, "value").toLowerCase();
        return summaryValue.contains(searchTerm) || keyValue.contains(searchTerm);
    }

    private static Optional<String> getFieldIdByName(List<Map> taskFields, String fieldName) {
        return taskFields.stream().filter(field -> fieldName.equals(field.get("name"))).map(field -> field.get("id").toString()).findFirst();
    }

    private static String getTaskFieldValue(TaskBoxFieldValues task, String fieldId, String fieldKey) {
        return Optional.ofNullable(task.getFields().get(fieldId)).map(field -> field.get(fieldKey)).map(Object::toString).orElse("");
    }
}

