/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommonUtils {
    static final String BP_DATE_FORMAT = "yyyy-MM-dd";

    public static Date parseDate(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(BP_DATE_FORMAT);
        formatter.setLenient(false);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isTaskEntityType(String entityName) {
        return "task".equalsIgnoreCase(entityName);
    }

    public static List<String> getFieldIdsByName(List<Map> fields, List<String> fieldNames) {
        if (CommonUtils.isNullOrEmpty(fields) || CommonUtils.isNullOrEmpty(fieldNames)) {
            return Collections.emptyList();
        }
        return fields.stream().filter(field -> fieldNames.contains(field.get("name"))).map(field -> Objects.toString(field.get("id"), "")).filter(id -> !id.isEmpty()).collect(Collectors.toList());
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

