/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.gadgets;

import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Service;

@Service
public class GadgetsRequesterControllerImpl
implements BeanFactoryAware,
GadgetsRequesterController {
    private static final Logger log = LoggerFactory.getLogger(GadgetsRequesterControllerImpl.class);
    @Inject
    private GadgetModelsFactory gadgetModelsFactory;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public GadgetRequester getGadgetRequester(GadgetModel gadget) throws GadgetRequesterException {
        String widget = gadget.getWidget();
        try {
            return (GadgetRequester)this.beanFactory.getBean(widget, GadgetRequester.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("Gadget Requester not found -> '" + widget + "'");
            throw new GadgetRequesterException("INVALID_GADGET", 409, (Exception)((Object)e));
        }
    }

    @Override
    public Object getDataFor(GadgetModel gadget, DatasourceModel datasource, List<String> extraParams, Map context) throws GadgetRequesterException {
        GadgetRequester requester = this.getGadgetRequester(gadget);
        requester.init(datasource, context);
        return requester.getData(gadget, extraParams);
    }

    @Override
    public GadgetModel findGadgetWithDatasource(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        return this.gadgetModelsFactory.getGadgetByRequester(gadgetRequest);
    }
}

