/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.gadgets;

import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.controllers.factories.GadgetModelFactory;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.TokenGeneratorImpl;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GadgetModelsFactoryImpl
implements GadgetModelsFactory {
    private static final Logger log = LoggerFactory.getLogger(GadgetModelsFactoryImpl.class);
    @Inject
    private Optional<List<GadgetModelFactory>> factories;
    @Inject
    private ApplicationPropertiesAccesor applicationPropertiesAccesor;
    @Inject
    private BoardsController boardsController;
    @Inject
    private DatasourcesControllerV2 datasourcesController;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private TokenGeneratorImpl tokenGenerator;

    @Override
    public GadgetModel getGadgetByRequester(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(gadgetRequest.getBoardToken());
        if (!this.isAppCustomGadget(tokenContent)) {
            return this.findBoardGadget(gadgetRequest, tokenContent);
        }
        return this.getGadgetByToken(tokenContent);
    }

    @Override
    public GadgetModel getGadgetByToken(TokenContentModel tokenContent) throws GadgetRequesterException {
        if (!this.isAppCustomGadget(tokenContent)) {
            throw new GadgetRequesterException("INVALID_GADGET_TOKEN", 400);
        }
        GadgetModelFactory gadgetFactory = this.getGadgetFactory();
        GadgetModel gadgetModel = gadgetFactory.getGadgetByToken(tokenContent);
        try {
            DatasourceModel ds = this.datasourcesController.getDatasource(gadgetModel.getConfig().getDatasource().getId());
            gadgetModel.getConfig().setDatasource(ds);
        }
        catch (IOException e) {
            log.error("Error getting datasource", (Throwable)e);
        }
        return gadgetModel;
    }

    private GadgetModelFactory getGadgetFactory() {
        GadgetModelFactory factory2;
        String app = this.applicationPropertiesAccesor.getApplicationName();
        if (this.factories.get() == null) {
            throw new RuntimeException("Not supported product");
        }
        List factories = this.factories.get().stream().filter(factory -> factory.match(app)).collect(Collectors.toList());
        switch (factories.size()) {
            case 0: {
                throw new RuntimeException("App not supported: " + app);
            }
            case 1: {
                factory2 = (GadgetModelFactory)factories.get(0);
                break;
            }
            default: {
                log.warn(String.format("Found multiple factories for an app: %s. Returning the first one.", app));
                factory2 = (GadgetModelFactory)factories.get(0);
            }
        }
        return factory2;
    }

    private GadgetModel findBoardGadget(GadgetRequestModel gadgetRequest, TokenContentModel tokenContent) throws GadgetRequesterException {
        BoardModel board = this.findBoard(tokenContent);
        if (!this.checkAuthorization(board)) {
            throw new GadgetRequesterException("OUTDATED_BOARD", 409);
        }
        GadgetModel gadget = this.findGadget(gadgetRequest, board);
        DatasourceModel ds = this.findDatasource(gadgetRequest, board, gadget, tokenContent.getUsserAccountId());
        gadget.getConfig().setDatasource(ds);
        return gadget;
    }

    private boolean isAppCustomGadget(TokenContentModel tokenContent) {
        return this.isJiraCustomGadget(tokenContent.getContainerId() != null && tokenContent.getItemId() != null);
    }

    private boolean isJiraCustomGadget(boolean tokenContent) {
        return tokenContent;
    }

    private boolean checkAuthorization(BoardModel board) {
        boolean isPublic = board.getSharing() != null && Boolean.TRUE.equals(board.getSharing().getPublic());
        return this.isJiraCustomGadget(isPublic || this.dhUserService.getLoggedInUserKey() != null);
    }

    private BoardModel findBoard(TokenContentModel tokenContent) throws GadgetRequesterException {
        BoardModel board;
        try {
            board = this.boardsController.getUserBoard(tokenContent.getUsserAccountId(), tokenContent.getBoardId(), tokenContent.getGlobal());
        }
        catch (Exception e) {
            board = null;
        }
        if (board == null) {
            throw new GadgetRequesterException("INVALID_WALLBOARD", 400);
        }
        return board;
    }

    private GadgetModel findGadget(GadgetRequestModel gadgetRequest, BoardModel board) throws GadgetRequesterException {
        try {
            GadgetModel gadget = gadgetRequest.getGadget();
            if (gadget == null && !(gadget = board.getData().get(gadgetRequest.getSlideIndex()).get(gadgetRequest.getGadgetIndex())).getId().equals(gadgetRequest.getGadgetId())) {
                throw new GadgetRequesterException("OUTDATED_BOARD", 409);
            }
            return gadget;
        }
        catch (GadgetRequesterException gre) {
            throw gre;
        }
        catch (Exception e) {
            throw new GadgetRequesterException("OUTDATED_BOARD", 409);
        }
    }

    private DatasourceModel findDatasource(GadgetRequestModel gadgetRequest, BoardModel board, GadgetModel gadget, String userKey) throws GadgetRequesterException {
        try {
            String dsId;
            DatasourceModel ds = gadgetRequest.getDatasource();
            if (ds == null) {
                dsId = gadget.getConfig().getDatasource().getId();
                ds = board.getDatasources().get(dsId);
            } else {
                dsId = ds.getId();
            }
            DatasourceModel dsFound = this.findDs(userKey, dsId, null);
            if (ProductHosting.DIRECT.value().equals(dsFound.getType())) {
                dsFound.setCreator(userKey);
            }
            return dsFound;
        }
        catch (Exception e) {
            throw new GadgetRequesterException("INVALID_DATASOURCE", 409, e);
        }
    }

    private DatasourceModel findDs(String userKey, String dsId, DatasourceModel def) throws Exception {
        try {
            return this.datasourcesController.getDatasource(dsId, def == null || def.getPrivate() != false, userKey);
        }
        catch (Exception e) {
            if (def == null) {
                return this.datasourcesController.getDatasource(dsId, false, userKey);
            }
            throw e;
        }
    }
}

