/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetConfigModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourcesControllerV2
implements DatasourcesController {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesControllerV2.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHDatasourcesRepository dsRepo;
    @Inject
    private DatasourceGenerator dsGenerator;
    @Inject
    private DatasourcesController dsController;

    @Override
    public List<DatasourceModel> getDatasources(String userKey, Boolean isPrivate) throws IOException {
        return isPrivate != false ? this.dsRepo.getPrivateDatasources(userKey) : this.dsRepo.getGlobalDatasources();
    }

    AppUser getLoggedInUser(boolean throwExceptionIfNotLogged) {
        AppUser user = this.dhUserService.getLoggedInUser();
        if (throwExceptionIfNotLogged && user == null) {
            throw new IllegalArgumentException("Get private datasources without a logged user is not possible");
        }
        return user;
    }

    @Override
    public List<DatasourceModel> getDatasources(Boolean isPrivate) throws IOException {
        AppUser user = this.getLoggedInUser(isPrivate);
        return this.getDatasources(user == null ? null : user.getKey(), isPrivate);
    }

    @Override
    public DatasourceModel getDatasource(String id) throws IOException {
        return this.dsRepo.getDatasource(id);
    }

    @Override
    public DatasourceModel getDatasource(String id, Boolean isPrivate, String userKey) throws IOException {
        return this.dsRepo.getDatasource(id);
    }

    @Override
    public boolean addDatasource(DatasourceModel newDs, Boolean isPrivate) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(isPrivate);
        DatasourceModel actualNewDs = this.dsGenerator.generateDatasource(newDs, datasources);
        return this.dsRepo.addDatasource(actualNewDs);
    }

    @Override
    public DatasourceModel removeDatasource(String id, Boolean isPrivate) throws IOException {
        String userKey = this.dhUserService.getLoggedInUserKey();
        DatasourceModel ds = this.getDatasource(id);
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue() && !ds.getCreator().equals(userKey)) {
            log.error("Problems with datasource: User not allowed to remove datasource.");
            throw new RuntimeException("User not allowed to remove datasource");
        }
        DatasourceModel removedDs = this.dsRepo.removeDatasource(id);
        return removedDs;
    }

    @Override
    public DatasourceModel getDefaultDatasource(String creator, String product) throws IOException {
        List<DatasourceModel> privateDatasources = this.dsRepo.getPrivateDatasources(creator);
        return privateDatasources.stream().filter(ds -> DatasourcesUtil.isDefaultDatasource(ds, product, creator)).findFirst().orElse(null);
    }

    @Override
    public void updateBoardDatasourcesWithNewOwner(BoardModel board, String newOwner) throws IOException {
        DatasourceModel newInstanceDatasource = this.dsController.getDefaultDatasource(newOwner, board.getProduct());
        if (newInstanceDatasource == null || board.getData() == null) {
            return;
        }
        AtomicBoolean instanceDatasourceAdded = new AtomicBoolean(false);
        List<List<GadgetModel>> updatedData = this.updateGadgetsWithNewDatasource(board, newInstanceDatasource, instanceDatasourceAdded);
        List<String> gadgetDatasourceIds = this.extractGadgetDatasourceIds(updatedData);
        List<DatasourceModel> boardDatasources = this.filterAndMapBoardDatasources(board, gadgetDatasourceIds);
        this.addNewInstanceDatasourceIfNeeded(boardDatasources, newInstanceDatasource, instanceDatasourceAdded);
        board.setDatasources(boardDatasources.stream().collect(Collectors.toMap(DatasourceModel::getId, ds -> new DatasourceModel(ds.getCreator(), ds.getPrivate()))));
        board.setData(updatedData);
    }

    private List<List<GadgetModel>> updateGadgetsWithNewDatasource(BoardModel board, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        return board.getData().stream().map(slide -> slide.stream().map(gadget -> {
            if (gadget.getConfig() == null || gadget.getConfig().getDatasource() == null) {
                return gadget;
            }
            DatasourceModel existingDatasource = null;
            try {
                existingDatasource = this.dsController.getDatasource(gadget.getConfig().getDatasource().getId());
            }
            catch (IOException e) {
                throw new RuntimeException("Problems getting datasource", e);
            }
            if (existingDatasource != null && DatasourcesUtil.isDefaultDatasource(existingDatasource, board.getProduct(), existingDatasource.getCreator())) {
                instanceDatasourceAdded.set(true);
                gadget.getConfig().setDatasource(new DatasourceModel(newInstanceDatasource.getId()));
            }
            return gadget;
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<String> extractGadgetDatasourceIds(List<List<GadgetModel>> updatedData) {
        return updatedData.stream().flatMap(Collection::stream).map(gadget -> Optional.ofNullable(gadget.getConfig()).map(GadgetConfigModel::getDatasource).map(DatasourceModel::getId).orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<DatasourceModel> filterAndMapBoardDatasources(BoardModel board, List<String> gadgetDatasourceIds) {
        return board.getDatasources().entrySet().stream().filter(entry -> gadgetDatasourceIds.contains(entry.getKey())).map(entry -> {
            ((DatasourceModel)entry.getValue()).setId((String)entry.getKey());
            return (DatasourceModel)entry.getValue();
        }).collect(Collectors.toList());
    }

    private void addNewInstanceDatasourceIfNeeded(List<DatasourceModel> boardDatasources, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        if (instanceDatasourceAdded.get() && boardDatasources.stream().noneMatch(ds -> ds.getId().equals(newInstanceDatasource.getId()))) {
            DatasourceModel reducedDatasource = new DatasourceModel(newInstanceDatasource.getId());
            reducedDatasource.setCreator(newInstanceDatasource.getCreator());
            reducedDatasource.setPrivate(newInstanceDatasource.getPrivate());
            boardDatasources.add(reducedDatasource);
        }
    }
}

