/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.statusPage;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.StatusPageConnector;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class StatusPageConnectorImpl
implements StatusPageConnector {
    private static final Logger log = LoggerFactory.getLogger(StatusPageConnectorImpl.class);
    private ServerConnector connector;

    public StatusPageConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        try {
            ResponseEntity<String> resp = this.getPages();
            return resp.getStatusCode().value() < 400;
        }
        catch (Exception e) {
            log.error("Validation of connector failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public ResponseEntity<String> getPages() {
        return this.connector.executeRequest("/v1/pages");
    }

    @Override
    public ResponseEntity<String> getPage(String id) {
        String path = String.format("/v1/pages/%s", id);
        return this.connector.executeRequest(path);
    }

    @Override
    public ResponseEntity<String> getPageIncidents(String id, Map<String, String> queryParams) {
        HashMap<String, String> actualParams = new HashMap<String, String>(queryParams);
        actualParams.putIfAbsent("page", "1");
        actualParams.putIfAbsent("limit", "100");
        String path = String.format("/v1/pages/%s/incidents", id);
        return this.connector.executeRequest(path, actualParams);
    }

    @Override
    public ResponseEntity<String> getPageComponents(String id, Map<String, String> queryParams) {
        HashMap<String, String> actualParams = new HashMap<String, String>(queryParams);
        actualParams.putIfAbsent("page", "1");
        actualParams.putIfAbsent("per_page", "100");
        String path = String.format("/v1/pages/%s/components", id);
        return this.connector.executeRequest(path, actualParams);
    }
}

