/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.server;

import com.atlassian.sal.api.net.Request;
import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.GetBoardsSprintsFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ServiceDeskAndQueues;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.getGroupUsersFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.jsonBeans.VersionBean;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.functions.ExecJQLServerFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.functions.GetAllFiltersServerFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.functions.GetJqlSuggestionsServer;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.functions.GetProjectServer;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class JiraRestConnector
implements JiraConnector,
ImageProvider {
    private static final Logger log = LoggerFactory.getLogger(JiraRestConnector.class);
    private static final int JIRA_MIN_VERSION = 800000;
    private static final Pattern PATTERN_ERROR_WITH_PROJECTS = Pattern.compile("'\\w+'");
    private ServerConnector connector;
    private DHObjectMapperImpl mapper;
    private List<Map> serviceDesks;
    private JiraIntegrationProperties jiraProps;

    public JiraRestConnector(ServerConnector connector, JiraIntegrationProperties integrationProps) {
        this.connector = connector;
        this.mapper = new DHObjectMapperImpl();
        this.jiraProps = integrationProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceDeskIdBy(String projectId) {
        JiraRestConnector jiraRestConnector = this;
        synchronized (jiraRestConnector) {
            if (this.serviceDesks == null) {
                this.serviceDesks = this.getAllServiceDesks(Collections.emptyMap());
            }
        }
        Map serviceDesk = this.serviceDesks.stream().filter(sd -> projectId.equals(sd.get("projectId"))).findAny().orElse(null);
        return serviceDesk != null ? (String)serviceDesk.get("id") : null;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        try {
            ResponseEntity<String> response = this.serverInfo();
            if (response.getStatusCode().value() >= 400) {
                return false;
            }
            Map data = this.mapper.readValue((String)response.getBody(), Map.class);
            int buildNumber = (Integer)data.get("buildNumber");
            return buildNumber >= 800000;
        }
        catch (Exception e) {
            log.error("Problems getting server info. URL base: " + this.getURL(), (Throwable)e);
            return false;
        }
    }

    List<String> getInvalidProjectsFrom(Map responseBody) {
        List errors = responseBody.getOrDefault("errorMessages", Collections.emptyList());
        return errors.stream().filter(msg -> msg.endsWith("the field 'project'.")).map(msg -> {
            Matcher m = PATTERN_ERROR_WITH_PROJECTS.matcher((CharSequence)msg);
            m.find();
            String v = m.group();
            return v.substring(1, v.length() - 1);
        }).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<List> getProjects(Map<String, Object> params) {
        HashMap<String, Object> _params = new HashMap<String, Object>(params);
        _params.remove("keys");
        ResponseEntity<List> response = this.connector.executeRequest("/rest/api/2/project", _params, List.class);
        if (response.getStatusCode().value() < 400) {
            try {
                List projectsJsm;
                List<Map> allProjects = this.mapper.convertValue(response.getBody(), new TypeReference<List<Map>>(){});
                List<Map> projects = allProjects;
                List prjKeys = (List)params.get("keys");
                if (prjKeys != null && !prjKeys.isEmpty()) {
                    projects = allProjects.stream().filter(aPrj -> prjKeys.contains(aPrj.get("key"))).collect(Collectors.toList());
                }
                if (_params != null && _params.containsKey("action") && _params.get("action").equals("browse") && projects.size() > 0) {
                    projects = this.removeInvalidProjects(projects);
                }
                if (!(projectsJsm = projects.stream().filter(aProject -> "service_desk".equals(aProject.get("projectTypeKey"))).collect(Collectors.toList())).isEmpty()) {
                    projects.stream().forEach(aProject -> {
                        if ("service_desk".equals(aProject.get("projectTypeKey"))) {
                            String serviceDeskId = this.getServiceDeskIdBy((String)aProject.get("id"));
                            aProject.put("serviceDeskId", serviceDeskId);
                        }
                    });
                }
                projects.stream().forEach(aProject -> aProject.put("style", "classic"));
                return new ResponseEntity(projects, response.getStatusCode());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return response;
    }

    private List<Map> removeInvalidProjects(List<Map> projects) {
        try {
            String projectJql = String.format("project IN (%s)", projects.stream().map(aProject -> String.format("'%s'", aProject.get("key"))).collect(Collectors.joining(", ")));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("maxResults", 1);
            params.put("loadAll", false);
            this.execJQL(projectJql, Arrays.asList("key"), null, null, params, null);
        }
        catch (BadRequestToSourceException badRequestException) {
            Map body = (Map)badRequestException.getResponseEntity().getBody();
            List<String> invalidKeys = this.getInvalidProjectsFrom(body);
            projects = projects.stream().filter(aProject -> !invalidKeys.contains(aProject.get("key"))).collect(Collectors.toList());
        }
        return projects;
    }

    @Override
    public ResponseEntity<Map> getProject(String projectIdOrKey) {
        return new GetProjectServer(this.connector).execute(projectIdOrKey);
    }

    @Override
    public ResponseEntity<Collection<VersionBean>> getProjectVersions(Long projectId, Map<String, Object> params) {
        String path = String.format("/rest/api/2/project/%s/versions", projectId);
        VersionBean[] versions = (VersionBean[])this.connector.executeRequest(path, params, VersionBean[].class).getBody();
        return new ResponseEntity(Arrays.asList(versions), HttpStatus.OK);
    }

    @Override
    public JQLResponse execJQL(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts, String userKey) {
        return new ExecJQLServerFunc(this.connector, this.jiraProps).exec(jql, fields, expand, properties, extraOpts);
    }

    @Override
    public ResponseEntity<String> autocomplete() {
        return this.connector.executeRequest("/rest/api/2/jql/autocompletedata");
    }

    @Override
    public ResponseEntity<List> getAllFilters(Map<String, ?> params, Map<String, Object> options) {
        return new GetAllFiltersServerFunc(this.connector).getAllFilters(params, options);
    }

    @Override
    public ResponseEntity<String> jqlProxy(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, ?> extraOpts, String userKey) {
        HashMap<String, Object> mParams = extraOpts == null ? new HashMap<String, Object>() : new HashMap(extraOpts);
        mParams.putIfAbsent("maxResults", 200);
        mParams.putIfAbsent("jql", jql);
        this.replaceInvalidExtraParams(mParams);
        if (fields != null) {
            mParams.putIfAbsent("fields", fields);
        }
        if (expand != null) {
            mParams.putIfAbsent("expand", expand);
        }
        if (properties != null) {
            mParams.putIfAbsent("properties", properties);
        }
        return this.connector.executeRequest(Request.MethodType.POST, "/rest/api/2/search", mParams, String.class);
    }

    private void replaceInvalidExtraParams(Map<String, Object> mParams) {
        if (mParams.containsKey("validateQuery")) {
            String validateQueryValue = (String)mParams.get("validateQuery");
            if (validateQueryValue.equals("strict")) {
                mParams.replace("validateQuery", "true");
            } else if (validateQueryValue.equals("warn") || validateQueryValue.equals("none")) {
                mParams.replace("validateQuery", "false");
            }
        }
    }

    @Override
    public ResponseEntity<List> getJqlSuggestions(Map<String, ?> params) {
        return new GetJqlSuggestionsServer(this.connector).getJqlSuggestions(params);
    }

    @Override
    public ResponseEntity<String> getProjectById(Long projectId) {
        return this.connector.executeRequest("/rest/api/2/project/" + projectId);
    }

    @Override
    public ResponseEntity<Map> getFilterById(Long filterId) {
        return this.connector.executeRequest("/rest/api/2/filter/" + filterId, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<String> getFields() throws Exception {
        return this.connector.executeRequest("/rest/api/2/field");
    }

    @Override
    public ResponseEntity<String> getIssue(Long id) throws Exception {
        return this.connector.executeRequest(String.format("/rest/api/2/issue/%d", id));
    }

    @Override
    public Map getIssueChangelog(Long issueId) throws Exception {
        Map<String, String> params = Collections.singletonMap("expand", "changelog");
        ResponseEntity<String> response = this.connector.executeRequest(String.format("/rest/api/2/issue/%d", issueId), params);
        Map issueData = ResponseChecker.checkStatusAndParse(response, Map.class);
        return (Map)issueData.get("changelog");
    }

    @Override
    public ResponseEntity<String> getIssueTypes() throws Exception {
        return this.connector.executeRequest("/rest/api/2/issuetype");
    }

    @Override
    public ResponseEntity<String> getStatuses() throws Exception {
        return this.connector.executeRequest("/rest/api/2/status");
    }

    @Override
    public ResponseEntity<String> getStatusCategory() throws Exception {
        return this.connector.executeRequest("/rest/api/2/statuscategory");
    }

    @Override
    public ResponseEntity<String> getPriorities() throws Exception {
        return this.connector.executeRequest("/rest/api/2/priority");
    }

    @Override
    public ResponseEntity<List> getBoards(Map<String, ?> params) throws Exception {
        HashMap<String, Integer> mParams = params == null ? new HashMap<String, Integer>() : new HashMap(params);
        mParams.putIfAbsent("startAt", 0);
        boolean moreData = true;
        LinkedList boards = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest("/rest/agile/1.0/board", mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            boards.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast");
            int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
            if (isLast != Boolean.TRUE && next < 1000) {
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(boards, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List> getBoardProjects(Long boardId) {
        String path = String.format("/rest/agile/1.0/board/%d/project", boardId);
        ResponseEntity<Map> resp = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        Map body = (Map)resp.getBody();
        List projects = body.containsKey("values") ? (List)body.get("values") : Collections.emptyList();
        return new ResponseEntity((Object)projects, resp.getStatusCode());
    }

    @Override
    public ResponseEntity<String> getBoardConfiguration(Long boardId) throws Exception {
        return this.connector.executeRequest(String.format("/rest/agile/1.0/board/%d/configuration", boardId));
    }

    @Override
    public ResponseEntity<List> getBoardsSprints(Long boardId, Map<String, ?> params, String userKey) {
        return this.getBoardsSprints(boardId, params, userKey, null);
    }

    @Override
    public ResponseEntity<List> getBoardsSprints(Long boardId, Map<String, ?> params, String userKey, Map<String, Object> paginationOptions) {
        return new GetBoardsSprintsFunc(this.connector).execute(boardId, params, paginationOptions);
    }

    @Override
    public ResponseEntity<Map> getServiceDesk(String projectId, Map<String, ?> params) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getServiceDesk(projectId, params);
    }

    @Override
    public List<Map> getAllServiceDesks(Map<String, ?> params) {
        return new ServiceDeskAndQueues(this.connector).getAllServiceDesks(params);
    }

    @Override
    public ResponseEntity<Map> getQueue(String serviceDeskId, String queueId) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getQueue(serviceDeskId, queueId);
    }

    @Override
    public List<Map> getQueues(String serviceDeskId, Map<String, ?> params) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getQueues(serviceDeskId, params);
    }

    @Override
    public ResponseEntity<String> me() {
        return this.connector.executeRequest("/rest/api/2/myself");
    }

    @Override
    public ResponseEntity<String> serverInfo() {
        return this.connector.executeRequest("/rest/api/2/serverInfo");
    }

    @Override
    public ResponseEntity<String> configuration() {
        return this.connector.executeRequest("/rest/api/2/configuration");
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "image/*");
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }

    @Override
    public ResponseEntity<List> getGroupUsers(String groupName, Map<String, ?> params, Map<String, Object> paginationOptions) {
        return new getGroupUsersFunc(this.connector).execute(groupName, params, paginationOptions);
    }

    private ResponseEntity<Map> getUser(String key) {
        return this.connector.executeRequest("/rest/api/2/user", Collections.singletonMap("key", key), Map.class);
    }

    @Override
    public List bulkGetUsers(Collection<String> userKeys) {
        int maxUsers = 20;
        List<String> limitedUserKeys = new ArrayList<String>(userKeys).subList(0, Math.min(userKeys.size(), maxUsers));
        return limitedUserKeys.parallelStream().map(userKey -> {
            ResponseEntity<Map> response = this.getUser((String)userKey);
            return response.getStatusCodeValue() < 300 ? (Map)response.getBody() : null;
        }).filter(u -> u != null).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<List> getFilteredProjects(String filter) {
        ResponseEntity<List> response = this.connector.executeRequest("/rest/api/2/project", Collections.emptyMap(), List.class);
        if (response.getStatusCode().value() < 400) {
            try {
                List<Map> projects = this.mapper.convertValue(response.getBody(), new TypeReference<List<Map>>(){});
                List<Map> projectsFiltered = projects.stream().filter(aProject -> aProject.get("key") != null && aProject.get("name") != null && (aProject.get("key").toString().toUpperCase().contains(filter.toUpperCase()) || aProject.get("name").toString().toUpperCase().contains(filter.toUpperCase()))).collect(Collectors.toList());
                projectsFiltered.forEach(aProject -> aProject.put("style", "classic"));
                return new ResponseEntity(projectsFiltered, response.getStatusCode());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return response;
    }

    @Override
    public Map getSprint(String sprintId) {
        String path = String.format("/rest/agile/1.0/sprint/%s", sprintId);
        ResponseEntity<Map> response = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        ResponseChecker.checkStatus(response);
        return (Map)response.getBody();
    }

    @Override
    public boolean isCloud() {
        return false;
    }
}

