/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.APITokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.SelfAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.bigpicture.cloud.BigPictureConnectorCloudImpl;
import com.roninpixels.dashboardhub.connectors.impl.bigpicture.server.BigPictureConnectorServerImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class BigPictureRestConnectorFactory
implements ConnectorFactory {
    public static final String RELATIVE_PATH_SERVER = "/rest/softwareplant-bigpicture/1.0";
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;

    RestAuthStrategy getAuthStrategy(DatasourceModel ds) {
        ProductHosting hosting = ProductHosting.valueOfType(ds.getType());
        if (hosting == null) {
            throw new RuntimeException("Hosting not supported by " + BigPictureRestConnectorFactory.class.getName() + ": " + ds.getType());
        }
        switch (hosting) {
            case CLOUD: 
            case DATACENTER: {
                return this.authStrategyFactory.getRestAuthStrategy(APITokenAuthStrategy.class, ds);
            }
        }
        return this.authStrategyFactory.getRestAuthStrategy(SelfAuthenticatorStrategy.class, ds);
    }

    String getUrlBaseForServerAPIs(DatasourceModel ds) {
        return ds.getUrl() + RELATIVE_PATH_SERVER;
    }

    ServerConnectorConfiguration getServerConnectorConfig(DatasourceModel ds) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        config.setUrlBaseForAPIs(this.getUrlBaseForServerAPIs(ds));
        return config;
    }

    ServerConnectorConfiguration getCloudConnectorConfig(String baseUrl) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        config.setUrlBaseForAPIs(baseUrl);
        return config;
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy strategy = this.getAuthStrategy(ds);
        ProductHosting hosting = ProductHosting.valueOfType(ds.getType());
        if (hosting == ProductHosting.CLOUD) {
            BigPictureConnectorCloudImpl connector = new BigPictureConnectorCloudImpl(this.serverConnectorFactory.getServerConnector(ds, strategy));
            return new BigPictureConnectorCloudImpl(this.serverConnectorFactory.getServerConnector(ds, strategy, this.getCloudConnectorConfig(connector.getBaseUrl())));
        }
        return new BigPictureConnectorServerImpl(this.serverConnectorFactory.getServerConnector(ds, strategy, this.getServerConnectorConfig(ds)));
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals(BigPictureConnector.PRODUCT);
    }
}

