/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.servicesImpl;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class ConfluenceApplicationPropertiesAccesor
implements ApplicationPropertiesAccesor {
    @Inject
    @ComponentImport
    private LocaleManager localeManager;
    @Inject
    private ApplicationProperties applicationProperties;

    @Override
    public String getAppProperty(String key, String defaultValue) {
        String value = null;
        switch (key) {
            case "baseURL": {
                value = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                break;
            }
            case "version": {
                value = this.applicationProperties.getVersion();
                break;
            }
            default: {
                value = defaultValue;
            }
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public String getSystemProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    @Override
    public String getDisplayName() {
        return "confluence";
    }

    @Override
    public String getApplicationName() {
        return "confluence";
    }

    @Override
    public Locale getDefaultLocale() {
        return this.localeManager.getSiteDefaultLocale();
    }

    @Override
    public String getSharedDashboardPath() {
        return "/plugins/servlet/dashboardHub/dashboard/shared";
    }

    @Override
    public String getInternalSharedDashboardPath() {
        return "/plugins/dashboardHub/dashboards.action";
    }

    @Override
    public String getToken() {
        return "6MGdbeSxxWj";
    }
}

